package ru.yandex.direct.core.entity.banner.service.execution;

import java.util.List;
import java.util.Set;

import org.jooq.DSLContext;
import org.jooq.TransactionalRunnable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannerRepositoryContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainerImpl;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.core.entity.banner.repository.BannerModifyRepository;
import ru.yandex.direct.core.entity.banner.service.BannerAdditionalActionsService;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateModerationService;
import ru.yandex.direct.core.entity.banner.service.type.update.BannerUpdateOperationTypeSupportFacade;
import ru.yandex.direct.core.entity.banner.type.bsresync.BannersUpdateBsResyncService;
import ru.yandex.direct.core.entity.banner.type.lastchange.BannersUpdateLastChangeResetService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerUtils.selectAppliedChanges;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Service
public class BannersUpdateExecutionMysqlService {

    private final DslContextProvider ppcDslContextProvider;
    private final BannerModifyRepository bannerModifyRepository;
    private final BannerUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade;
    private final BannerAdditionalActionsService additionalActionsService;
    private final BannersUpdateModerationService moderationService;
    private final BannersUpdateBsResyncService bsResyncService;
    private final BannersUpdateLastChangeResetService lastChangeResetService;

    @Autowired
    public BannersUpdateExecutionMysqlService(DslContextProvider ppcDslContextProvider,
                                              BannerModifyRepository bannerModifyRepository,
                                              BannerUpdateOperationTypeSupportFacade updateOperationTypeSupportFacade,
                                              BannerAdditionalActionsService additionalActionsService,
                                              BannersUpdateModerationService moderationService,
                                              BannersUpdateBsResyncService bsResyncService,
                                              BannersUpdateLastChangeResetService lastChangeResetService) {
        this.ppcDslContextProvider = ppcDslContextProvider;
        this.bannerModifyRepository = bannerModifyRepository;
        this.updateOperationTypeSupportFacade = updateOperationTypeSupportFacade;
        this.additionalActionsService = additionalActionsService;
        this.moderationService = moderationService;
        this.bsResyncService = bsResyncService;
        this.lastChangeResetService = lastChangeResetService;
    }

    public <T extends Banner> List<Long> execute(List<AppliedChanges<T>> applicableAppliedChanges,
                                                 BannersUpdateOperationContainerImpl operationContainer,
                                                 BannerRepositoryContainer repositoryContainer,
                                                 BannerAdditionalActionsContainer additionalActionsContainer) {
        var applicableAppliedChangesToModeration = mapList(applicableAppliedChanges,
                c -> c.castModelUp(BannerWithModerationStatuses.class));

        Set<Long> bannerIdsToBsResync = updateOperationTypeSupportFacade.getNeedBsResyncIds(applicableAppliedChanges);
        bsResyncService.resetBsSyncStatus(operationContainer, bannerIdsToBsResync, applicableAppliedChanges);

        Set<Long> bannerIdsToLastChangeReset =
                updateOperationTypeSupportFacade.getNeedLastChangeResetIds(applicableAppliedChanges);
        lastChangeResetService.reset(bannerIdsToLastChangeReset, applicableAppliedChanges);

        updateOperationTypeSupportFacade.addToAdditionalActionsContainer(additionalActionsContainer, operationContainer,
                applicableAppliedChanges);

        moderationService.sendBannersToModeration(operationContainer,
                additionalActionsContainer,
                updateOperationTypeSupportFacade.getNeedModerationIds(operationContainer, applicableAppliedChanges),
                applicableAppliedChangesToModeration);

        ppcDslContextProvider.ppcTransaction(operationContainer.getShard(),
                createTransactionalUpdateTask(applicableAppliedChanges, operationContainer, repositoryContainer,
                        additionalActionsContainer));

        updateOperationTypeSupportFacade.updateRelatedEntitiesOutOfTransaction(operationContainer,
                applicableAppliedChanges);
        return mapList(applicableAppliedChanges, b -> b.getModel().getId());
    }

    private <T extends Banner> TransactionalRunnable createTransactionalUpdateTask(
            List<AppliedChanges<T>> validAppliedChanges,
            BannersUpdateOperationContainerImpl operationContainer,
            BannerRepositoryContainer repositoryContainer,
            BannerAdditionalActionsContainer additionalActionsContainer) {
        return configuration -> {
            DSLContext dsl = configuration.dsl();
            updateOperationTypeSupportFacade.beforeExecutionInTransaction(dsl, additionalActionsContainer,
                    operationContainer, validAppliedChanges);

            List<AppliedChanges<BannerWithAdGroupId>> validAppliedChanges2 = selectAppliedChanges(
                    validAppliedChanges, BannerWithAdGroupId.class);

            bannerModifyRepository.update(dsl, repositoryContainer, validAppliedChanges2);

            updateOperationTypeSupportFacade
                    .updateRelatedEntitiesInTransaction(dsl, operationContainer, validAppliedChanges);

            additionalActionsService
                    .processAdditionalActionsContainer(dsl, additionalActionsContainer);
        };
    }
}
