package ru.yandex.direct.core.entity.banner.service.execution

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.creative.model.Creative
import ru.yandex.direct.core.entity.uac.grut.GrutContext
import ru.yandex.direct.core.entity.uac.grut.GrutTransactionProvider
import ru.yandex.direct.core.entity.vcard.model.Vcard
import ru.yandex.direct.core.grut.api.CreativeGrutApi
import ru.yandex.direct.core.grut.api.CreativeGrutModel
import ru.yandex.direct.core.grut.api.GrutApiBase
import ru.yandex.direct.core.grut.api.VCardGrutApi
import ru.yandex.direct.core.grut.api.VCardGrutModel
import ru.yandex.direct.dbutil.model.ClientId

@Service
class GrutStubObjectsService(
    grutContext: GrutContext,
    private val grutTransactionProvider: GrutTransactionProvider,
) {
    private val vcardGrutApi = VCardGrutApi(grutContext)
    private val creativeGrutApi = CreativeGrutApi(grutContext)

    /**
     * Создаёт заглушки для тех визиток, которых ещё нет в груте
     * Это нужно для последующего создания баннеров: vcard_id должен указывать на существующий объект
     * А само тело объекта приедет по репликации
     */
    fun createStubsForMissingVcards(clientId: ClientId, vcardIds: Collection<Long>) {
        if (vcardIds.isEmpty()) {
            return
        }
        grutTransactionProvider.runRetryable(GrutApiBase.GRUT_CHANGE_OBJECTS_ATTEMPTS) {
            val existingVcards = vcardGrutApi.getVCards(vcardIds)

            val missingVcardIds = vcardIds.toSet().minus(existingVcards.map { it.meta.id }.toSet())
            if (missingVcardIds.isNotEmpty()) {
                val vcardsToCreate = missingVcardIds.map {
                    VCardGrutModel(
                        vcard = Vcard().withId(it),
                        clientId = clientId.asLong(),
                        null,
                        null,
                        null
                    )
                }
                vcardGrutApi.createObjects(vcardsToCreate)
            }
        }
    }

    fun createStubsForMissingCreatives(
        clientId: ClientId,
        creativeIds: Collection<Long>,
        creativeByIdMap: Map<Long, Creative>
    ) {
        if (creativeIds.isEmpty()) {
            return
        }

        grutTransactionProvider.runRetryable(GrutApiBase.GRUT_CHANGE_OBJECTS_ATTEMPTS) {
            val existingCreatives = creativeGrutApi.getCreatives(creativeIds)

            val missingCreativeIds = creativeIds.toSet().minus(existingCreatives.map { it.meta.id }.toSet())
            if (missingCreativeIds.isNotEmpty()) {
                val creativesToCreate = missingCreativeIds.map {
                    CreativeGrutModel(
                        creative = creativeByIdMap[it]!!,
                        clientId = clientId.asLong()
                    )
                }
                creativeGrutApi.createObjects(creativesToCreate)
            }
        }
    }
}
