package ru.yandex.direct.core.entity.banner.service.moderation;

import java.util.List;

import org.jooq.DSLContext;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationStatuses;
import ru.yandex.direct.model.AppliedChanges;

public abstract class AbstractBannerWithChildrenModerationProcessor<T extends BannerWithModerationStatuses, C>
        implements BannerWithChildrenModerationProcessor<T> {

    @Override
    final public void process(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer container,
            List<AppliedChanges<T>> appliedChanges) {
        C moderationContainer = prepareContainer(container, appliedChanges);
        appliedChanges.forEach(ac -> process(additionalActionsContainer, container, moderationContainer, ac));
        postProcess(dsl, container, moderationContainer);
    }

    protected abstract C prepareContainer(BannersUpdateOperationContainer container,
                                          List<AppliedChanges<T>> appliedChanges);

    protected abstract void process(BannerAdditionalActionsContainer additionalActionsContainer,
                                    BannersUpdateOperationContainer container,
                                    C moderationContainer,
                                    AppliedChanges<T> changes);

    protected void postProcess(DSLContext dsl,
                               BannersUpdateOperationContainer container,
                               C moderationContainer) {
    }
}
