package ru.yandex.direct.core.entity.banner.service.moderation;

public enum ModerationMode {

    /**
     * NOTE: краткое описание, на самом деле все может быть сложнее.
     * Если при редактировании баннер в статусе черновика (StatusModerate.NEW),
     * то он остается в этом статусе независимо от характера изменений.
     * Если кампания данного баннера находится в статусе черновика,
     * то баннер сохраняется в статусе черновика.
     * Если баннер и кампания не являются черновиками, то баннер отправляется на модерацию
     * либо при значимых изменениях, либо если он хоть как-то изменён и находится в статусах No, Sending, Sent.
     * <p>
     * Если баннер отправляется на модерацию, а группа находится в статусе черновика,
     * то и группа отправляется на модерацию.
     * <p>
     * Если баннер отправляется на модерацию, а кампания находится в статусе "отклонена на модерации",
     * то и кампания переотправляется на модерацию.
     */
    DEFAULT,

    /**
     * Баннер принудительно сохраняется в статусе StatusModerate.New (черновик)
     * независимо от предыдущего статуса и характера изменений.
     */
    FORCE_SAVE_DRAFT,

    /**
     * NOTE: краткое описание, на самом деле все может быть сложнее.
     * <p>
     * Если баннер был черновиком и при этом кампания не является черновиком,
     * то баннер отправляется на модерацию.
     * Если баннер не был черновиком и при этом кампания не является черновиком,
     * то баннер отправляется на модерацию при значимых изменениях или если он был в статусах
     * No, Sending, Sent.
     * Если кампания является черновиком, то баннер сохраняется в статусе черновика.
     * <p>
     * Если баннер отправляется на модерацию, а группа находится в статусе черновика,
     * то и группа отправляется на модерацию.
     * <p>
     * Если баннер отправляется на модерацию, а кампания находится в статусе "отклонена на модерации",
     * то и кампания переотправляется на модерацию.
     */
    FORCE_MODERATE;

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean isForceSaveDraft() {
        return this == FORCE_SAVE_DRAFT;
    }

    public boolean isForceModerate() {
        return this == FORCE_MODERATE;
    }
}
