package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.DynSmartAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.StatusBLGenerated;
import ru.yandex.direct.core.entity.adgroup.model.StatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerDisplayHrefStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerMulticardSetStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusSitelinksModerate;
import ru.yandex.direct.core.entity.banner.model.BannerTurboLandingStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerVcardStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.model.BannerWithImage;
import ru.yandex.direct.core.entity.banner.model.BannerWithMulticardSet;
import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinks;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.BannerWithTurboLanding;
import ru.yandex.direct.core.entity.banner.model.BannerWithVcard;
import ru.yandex.direct.core.entity.banner.model.NewStatusImageModerate;
import ru.yandex.direct.core.entity.banner.model.StatusBannerImageModerate;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

/**
 * TypeSupport для модерации баннеров
 */
@ParametersAreNonnullByDefault
public interface BannerModerateOperationSupport<A extends AdGroup, B extends BannerWithSystemFields> {

    Class<A> getAdGroupClass();

    Class<B> getBannerClass();

    default void commonModerationProcedure(AppliedChanges<A> adGroupChanges, AppliedChanges<B> bannerChanges,
                                           BannerModerateOptions options) {
        bannerChanges.modifyIf(BannerWithSystemFields.STATUS_MODERATE, BannerStatusModerate.READY,
                b -> (!options.getFilterSendingAndSent()
                        || b.getStatusModerate() == BannerStatusModerate.SENT
                        || b.getStatusModerate() == BannerStatusModerate.SENDING));
        bannerChanges.modifyIf(BannerWithSystemFields.STATUS_POST_MODERATE, BannerStatusPostModerate.NO,
                b -> b.getStatusPostModerate() != BannerStatusPostModerate.REJECTED);
        // при отправке с фильтрацией по статусам учитываем следующую логику:
        // если переотправляется сам баннер - то переотправляются и все его подобъекты (визитка и сайтлинки)
        bannerChanges.modifyIf(BannerWithVcard.VCARD_STATUS_MODERATE,
                BannerVcardStatusModerate.READY,
                BannerWithVcard.class,
                b -> b.getVcardId() != null
                        && (!options.getFilterSendingAndSent()
                        || b.getVcardStatusModerate() == BannerVcardStatusModerate.SENT
                        || b.getVcardStatusModerate() == BannerVcardStatusModerate.SENDING
                        || statusModerateIsSendingOrSent(bannerChanges)));
        bannerChanges.modifyIf(BannerWithSitelinks.STATUS_SITELINKS_MODERATE, BannerStatusSitelinksModerate.READY,
                BannerWithSitelinks.class,
                b -> b.getSitelinksSetId() != null
                        && (!options.getFilterSendingAndSent()
                        || b.getStatusSitelinksModerate() == BannerStatusSitelinksModerate.SENT
                        || b.getStatusSitelinksModerate() == BannerStatusSitelinksModerate.SENDING
                        || statusModerateIsSendingOrSent(bannerChanges)));
        bannerChanges.modifyIf(BannerWithDisplayHref.DISPLAY_HREF_STATUS_MODERATE,
                BannerDisplayHrefStatusModerate.READY,
                BannerWithDisplayHref.class,
                b -> b.getDisplayHref() != null
                        && (!options.getFilterSendingAndSent()
                        || b.getDisplayHrefStatusModerate() == BannerDisplayHrefStatusModerate.SENT
                        || b.getDisplayHrefStatusModerate() == BannerDisplayHrefStatusModerate.SENDING));
        bannerChanges.modifyIf(BannerWithTurboLanding.TURBO_LANDING_STATUS_MODERATE,
                BannerTurboLandingStatusModerate.READY,
                BannerWithTurboLanding.class,
                b -> b.getTurboLandingId() != null
                        && (!options.getFilterSendingAndSent()
                        || b.getTurboLandingStatusModerate() == BannerTurboLandingStatusModerate.SENT
                        || b.getTurboLandingStatusModerate() == BannerTurboLandingStatusModerate.SENDING));
        bannerChanges.modifyIf(BannerWithBannerImage.IMAGE_STATUS_MODERATE,
                StatusBannerImageModerate.READY,
                BannerWithBannerImage.class,
                b -> b.getImageId() != null
                        && (!options.getFilterSendingAndSent()
                        || b.getImageStatusModerate() == StatusBannerImageModerate.SENT
                        || b.getImageStatusModerate() == StatusBannerImageModerate.SENDING));
        bannerChanges.modifyIf(BannerWithImage.IMAGE_STATUS_MODERATE,
                NewStatusImageModerate.READY,
                BannerWithImage.class,
                b -> b.getImageId() != null
                        && (!options.getFilterSendingAndSent()
                        || b.getImageStatusModerate() == NewStatusImageModerate.SENT
                        || b.getImageStatusModerate() == NewStatusImageModerate.SENDING));
        bannerChanges.modifyIf(BannerWithMulticardSet.MULTICARD_SET_STATUS_MODERATE,
                BannerMulticardSetStatusModerate.READY,
                BannerWithMulticardSet.class,
                b -> b.getMulticards() != null
                 && (!options.getFilterSendingAndSent()
                        || b.getMulticardSetStatusModerate() == BannerMulticardSetStatusModerate.SENT
                        || b.getMulticardSetStatusModerate() == BannerMulticardSetStatusModerate.SENDING));
        Set<StatusModerate> statusModerateToProcess = options.getFilterSendingAndSent()
                ? Set.of(StatusModerate.SENDING, StatusModerate.SENT)
                : Set.of(StatusModerate.NEW, StatusModerate.NO);
        if (statusModerateToProcess.contains(adGroupChanges.getModel().getStatusModerate())) {
            adGroupChanges.modify(AdGroup.STATUS_MODERATE, StatusModerate.READY);
            adGroupChanges.modify(AdGroup.STATUS_POST_MODERATE,
                    ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate.NO);
        }
    }

    default boolean statusModerateIsSendingOrSent(AppliedChanges<B> bannerChanges) {
        BannerStatusModerate statusModerate = bannerChanges.getOldValue(BannerWithSystemFields.STATUS_MODERATE);
        return statusModerate == BannerStatusModerate.SENT
                || statusModerate == BannerStatusModerate.SENDING;
    }

    default void dynSmartModerationProcedure(AppliedChanges<A> adGroupChanges,
                                             BannerModerateOptions options) {
        adGroupChanges.modifyIf(DynSmartAdGroup.STATUS_B_L_GENERATED, StatusBLGenerated.PROCESSING,
                DynSmartAdGroup.class, dynSmartAdGroup ->
                {
                    StatusModerate adgroupStatusModerate = adGroupChanges.getOldValue(AdGroup.STATUS_MODERATE);
                    return !options.getFilterSendingAndSent()
                            || adgroupStatusModerate == StatusModerate.SENDING
                            || adgroupStatusModerate == StatusModerate.SENT;
                });
    }

    @SuppressWarnings("unchecked")
    default void commonRemoderationProcedure(AppliedChanges<B> bannerChanges,
                                             Set<RemoderationType> remoderationTypes) {
        var model = bannerChanges.getModel();

        if (model.getStatusModerate() == BannerStatusModerate.NO) {
            modifyModerateStatus(bannerChanges, BannerWithSystemFields.STATUS_POST_MODERATE,
                    BannerStatusPostModerate.NO);
            RemoderationType remoderationType = modifyModerateStatus(bannerChanges,
                    BannerWithSystemFields.STATUS_MODERATE, BannerStatusModerate.READY);
            remoderationTypes.add(remoderationType);
        }

        if (contactsStatusModerateShouldBeReady(model)) {
            RemoderationType remoderationType =
                    modifyModerateStatus((AppliedChanges<? extends BannerWithVcard>) bannerChanges,
                            BannerWithVcard.VCARD_STATUS_MODERATE, BannerVcardStatusModerate.READY);
            remoderationTypes.add(remoderationType);
        }

        if (sitelinksStatusModerateShouldBeReady(model)) {
            RemoderationType remoderationType =
                    modifyModerateStatus((AppliedChanges<? extends BannerWithSitelinks>) bannerChanges,
                            BannerWithSitelinks.STATUS_SITELINKS_MODERATE, BannerStatusSitelinksModerate.READY);
            remoderationTypes.add(remoderationType);
        }

        if (displayHrefStatusModerateShouldBeReady(model)) {
            RemoderationType remoderationType =
                    modifyModerateStatus((AppliedChanges<? extends BannerWithDisplayHref>) bannerChanges,
                            BannerWithDisplayHref.DISPLAY_HREF_STATUS_MODERATE, BannerDisplayHrefStatusModerate.READY);
            remoderationTypes.add(remoderationType);
        }

        if (turbolandingStatusModerateShouldBeReady(model)) {
            RemoderationType remoderationType =
                    modifyModerateStatus((AppliedChanges<? extends BannerWithTurboLanding>) bannerChanges,
                            BannerWithTurboLanding.TURBO_LANDING_STATUS_MODERATE,
                            BannerTurboLandingStatusModerate.READY);
            remoderationTypes.add(remoderationType);
        }

        if (bannerImageStatusModerateShouldBeReady(model)) {
            RemoderationType remoderationType =
                    modifyModerateStatus((AppliedChanges<? extends BannerWithBannerImage>) bannerChanges,
                            BannerWithBannerImage.IMAGE_STATUS_MODERATE, StatusBannerImageModerate.READY);
            remoderationTypes.add(remoderationType);
        }

        if (imageStatusModerateShouldBeReady(model)) {
            RemoderationType remoderationType =
                    modifyModerateStatus((AppliedChanges<? extends BannerWithImage>) bannerChanges,
                            BannerWithImage.IMAGE_STATUS_MODERATE, NewStatusImageModerate.READY);
            remoderationTypes.add(remoderationType);
        }

        if (multicardSetStatusModerateShouldBeReady(model)) {
            RemoderationType remoderationType
                    = modifyModerateStatus((AppliedChanges<? extends BannerWithMulticardSet>) bannerChanges,
                    BannerWithMulticardSet.MULTICARD_SET_STATUS_MODERATE, BannerMulticardSetStatusModerate.READY);
            remoderationTypes.add(remoderationType);
        }
    }

    /**
     * Проставить статусы модерации баннерам, группам и креативам (если они есть)
     */
    void moderate(AppliedChanges<A> adGroupChanges,
                  AppliedChanges<B> bannerChanges,
                  @Nullable AppliedChanges<Creative> creativeChanges,
                  BannerModerateOptions options);

    /**
     * Проставить статусы модерации баннерам и креативам (если они есть), для отклоненных объектов
     */
    void remoderate(AppliedChanges<B> bannerChanges, @Nullable AppliedChanges<Creative> creativeChanges,
                    Set<RemoderationType> remoderationTypes);

    /**
     * Добавляет в changes изменение заданного статуса модерации
     *
     * @return тип объекта для переотравки
     */
    private static <T extends ModelWithId, V> RemoderationType modifyModerateStatus(
            AppliedChanges<? extends T> bannerChanges, ModelProperty<? super T, V> property, V value) {
        bannerChanges.modify(property, value);
        if (BannerWithSystemFields.STATUS_MODERATE.equals(property)) {
            return RemoderationType.BANNER;
        }
        if (BannerWithSitelinks.STATUS_SITELINKS_MODERATE.equals(property)) {
            return RemoderationType.SITELINKS_SET;
        }
        if (BannerWithVcard.VCARD_STATUS_MODERATE.equals(property)) {
            return RemoderationType.CONTACTS;
        }
        if (BannerWithDisplayHref.DISPLAY_HREF_STATUS_MODERATE.equals(property)) {
            return RemoderationType.DISPLAY_HREFS;
        }
        if (BannerWithTurboLanding.TURBO_LANDING_STATUS_MODERATE.equals(property)) {
            return RemoderationType.TURBOLANDING;
        }
        if (BannerWithBannerImage.IMAGE_STATUS_MODERATE.equals(property)) {
            return RemoderationType.BANNER_IMAGE;
        }
        if (BannerWithImage.IMAGE_STATUS_MODERATE.equals(property)) {
            return RemoderationType.IMAGE;
        }
        if (BannerWithMulticardSet.MULTICARD_SET_STATUS_MODERATE.equals(property)) {
            return RemoderationType.MULTICARD;
        }
        return null;
    }

    private boolean contactsStatusModerateShouldBeReady(B model) {
        return BannerWithVcard.class.isAssignableFrom(model.getClass()) &&
                ((BannerWithVcard) model).getVcardId() != null &&
                ((BannerWithVcard) model).getVcardStatusModerate() == BannerVcardStatusModerate.NO;
    }

    private boolean sitelinksStatusModerateShouldBeReady(B model) {
        return BannerWithSitelinks.class.isAssignableFrom(model.getClass()) &&
                ((BannerWithSitelinks) model).getSitelinksSetId() != null &&
                ((BannerWithSitelinks) model).getStatusSitelinksModerate() == BannerStatusSitelinksModerate.NO;
    }

    private boolean displayHrefStatusModerateShouldBeReady(B model) {
        return BannerWithDisplayHref.class.isAssignableFrom(model.getClass()) &&
                ((BannerWithDisplayHref) model).getDisplayHref() != null &&
                ((BannerWithDisplayHref) model).getDisplayHrefStatusModerate() == BannerDisplayHrefStatusModerate.NO;
    }

    private boolean turbolandingStatusModerateShouldBeReady(B model) {
        return BannerWithTurboLanding.class.isAssignableFrom(model.getClass()) &&
                ((BannerWithTurboLanding) model).getTurboLandingId() != null &&
                ((BannerWithTurboLanding) model).getTurboLandingStatusModerate()
                        == BannerTurboLandingStatusModerate.NO;
    }

    private boolean bannerImageStatusModerateShouldBeReady(B model) {
        return BannerWithBannerImage.class.isAssignableFrom(model.getClass()) &&
                ((BannerWithBannerImage) model).getImageId() != null &&
                ((BannerWithBannerImage) model).getImageStatusModerate() == StatusBannerImageModerate.NO;
    }

    private boolean imageStatusModerateShouldBeReady(B model) {
        return BannerWithImage.class.isAssignableFrom(model.getClass()) &&
                ((BannerWithImage) model).getImageId() != null &&
                ((BannerWithImage) model).getImageStatusModerate() == NewStatusImageModerate.NO;
    }

    private boolean multicardSetStatusModerateShouldBeReady(B model) {
        return BannerWithMulticardSet.class.isAssignableFrom(model.getClass()) &&
                ((BannerWithMulticardSet) model).getMulticards() != null &&
                ((BannerWithMulticardSet) model).getMulticardSetStatusModerate() == BannerMulticardSetStatusModerate.NO;
    }

}
