package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Maps;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.AppliedChanges;

import static com.google.common.base.Preconditions.checkArgument;

@Component
@ParametersAreNonnullByDefault
public class BannerModerateOperationSupportFacade {
    private final Map<Class<?>, BannerModerateOperationSupport> supportMap;

    public BannerModerateOperationSupportFacade(List<BannerModerateOperationSupport> bannerModerateOperationSupports) {
        this.supportMap = Maps.uniqueIndex(bannerModerateOperationSupports,
                BannerModerateOperationSupport::getBannerClass);
    }

    public <A extends AdGroup, B extends BannerWithSystemFields> BannerModerateOperationSupport<A, B>
    getModerateOperationSupport(
            AppliedChanges<B> appliedChanges) {
        B model = appliedChanges.getModel();
        checkArgument(supportMap.containsKey(model.getClass()));
        return supportMap.get(model.getClass());
    }
}
