package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdGroup;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

/**
 * {@link BannerModerateOperationSupport} для баннеров продвижения контента.
 */
@Component
@ParametersAreNonnullByDefault
public class ContentPromotionBannerModerateOperationSupport implements
        BannerModerateOperationSupport<ContentPromotionAdGroup, ContentPromotionBanner> {

    @Override
    public Class<ContentPromotionAdGroup> getAdGroupClass() {
        return ContentPromotionAdGroup.class;
    }

    @Override
    public Class<ContentPromotionBanner> getBannerClass() {
        return ContentPromotionBanner.class;
    }

    @Override
    public void moderate(AppliedChanges<ContentPromotionAdGroup> adGroupChanges,
                         AppliedChanges<ContentPromotionBanner> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
    }

    @Override
    public void remoderate(AppliedChanges<ContentPromotionBanner> bannerChanges,
                           @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);
    }

}
