package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CpcVideoBannerModerateOperationSupport implements BannerModerateOperationSupport<AdGroup, CpcVideoBanner> {
    @Override
    public Class<AdGroup> getAdGroupClass() {
        return AdGroup.class;
    }

    @Override
    public Class<CpcVideoBanner> getBannerClass() {
        return CpcVideoBanner.class;
    }

    @Override
    public void moderate(AppliedChanges<AdGroup> adGroupChanges,
                         AppliedChanges<CpcVideoBanner> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
        setCreativeStatusModerate(bannerChanges);
    }

    @Override
    public void remoderate(AppliedChanges<CpcVideoBanner> bannerChanges,
                           @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);

        bannerChanges.modifyIf(BannerWithCreative.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY,
                BannerWithCreative.class,
                b -> b.getCreativeId() != null && b.getCreativeStatusModerate() == BannerCreativeStatusModerate.NO);
    }

    private void setCreativeStatusModerate(AppliedChanges<CpcVideoBanner> bannerChanges) {
        if (bannerChanges.getModel().getStatusModerate() == BannerStatusModerate.READY
                && bannerChanges.getModel().getCreativeStatusModerate() == BannerCreativeStatusModerate.NEW) {
            bannerChanges.modify(CpcVideoBanner.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY);
        }
    }

}
