package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.CpmBannerAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.model.CreativeType;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CpmBannerModerateOperationSupport implements BannerModerateOperationSupport<CpmBannerAdGroup, CpmBanner> {
    @Override
    public Class<CpmBannerAdGroup> getAdGroupClass() {
        return CpmBannerAdGroup.class;
    }

    @Override
    public Class<CpmBanner> getBannerClass() {
        return CpmBanner.class;
    }

    @Override
    public void moderate(AppliedChanges<CpmBannerAdGroup> adGroupChanges,
                         AppliedChanges<CpmBanner> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
        setCreativeStatusModerate(bannerChanges, creativeChanges);
    }

    @Override
    public void remoderate(AppliedChanges<CpmBanner> bannerChanges,
                           @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);
        setCreativeStatusModerate(bannerChanges, creativeChanges);
        if (bannerChanges.changed(CpmBanner.STATUS_MODERATE)) {
            remoderationTypes.add(RemoderationType.BANNER);
        }
    }

    private void setCreativeStatusModerate(AppliedChanges<CpmBanner> bannerChanges,
                                           @Nullable AppliedChanges<Creative> creativeChanges) {
        if (bannerChanges.getModel().getStatusModerate() == BannerStatusModerate.READY
                && creativeChanges != null
                && bannerChanges.getModel().getCreativeStatusModerate() == BannerCreativeStatusModerate.NEW) {
            bannerChanges.modify(CpmBanner.CREATIVE_STATUS_MODERATE,
                    creativeChanges.getModel().getType() == CreativeType.VIDEO_ADDITION_CREATIVE
                            ? BannerCreativeStatusModerate.YES
                            : BannerCreativeStatusModerate.READY);
        }
    }

}
