package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class ImageBannerModerateOperationSupport implements BannerModerateOperationSupport<AdGroup, ImageBanner> {
    @Override
    public Class<AdGroup> getAdGroupClass() {
        return AdGroup.class;
    }

    @Override
    public Class<ImageBanner> getBannerClass() {
        return ImageBanner.class;
    }

    @Override
    public void moderate(AppliedChanges<AdGroup> adGroupChanges,
                         AppliedChanges<ImageBanner> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
        if (bannerChanges.getModel().getStatusModerate() == BannerStatusModerate.READY
                && bannerChanges.getModel().getCreativeStatusModerate() == BannerCreativeStatusModerate.NEW) {
            bannerChanges.modify(ImageBanner.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY);
        }
    }

    @Override
    public void remoderate(AppliedChanges<ImageBanner> bannerChanges,
                           @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);
    }

}
