package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class McBannerModerateOperationSupport
        implements BannerModerateOperationSupport<AdGroup, McBanner> {
    @Override
    public Class<AdGroup> getAdGroupClass() {
        return AdGroup.class;
    }

    @Override
    public Class<McBanner> getBannerClass() {
        return McBanner.class;
    }

    @Override
    public void moderate(AppliedChanges<AdGroup> adGroupChanges,
                         AppliedChanges<McBanner> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
    }

    @Override
    public void remoderate(AppliedChanges<McBanner> bannerChanges, @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);
    }

}
