package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public
class MobileAppBannerModerateOperationSupport
        implements BannerModerateOperationSupport<MobileContentAdGroup, MobileAppBanner> {
    @Override
    public Class<MobileContentAdGroup> getAdGroupClass() {
        return MobileContentAdGroup.class;
    }

    @Override
    public Class<MobileAppBanner> getBannerClass() {
        return MobileAppBanner.class;
    }

    @Override
    public void moderate(AppliedChanges<MobileContentAdGroup> adGroupChanges,
                         AppliedChanges<MobileAppBanner> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
        bannerChanges.modifyIf(BannerWithCreative.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY,
                BannerWithCreative.class,
                b -> b.getCreativeId() != null
                        && (!options.getFilterSendingAndSent()
                        || b.getCreativeStatusModerate() == BannerCreativeStatusModerate.SENT
                        || b.getCreativeStatusModerate() == BannerCreativeStatusModerate.SENDING));
    }

    @Override
    public void remoderate(AppliedChanges<MobileAppBanner> bannerChanges,
                           @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);

        bannerChanges.modifyIf(BannerWithCreative.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY,
                BannerWithCreative.class,
                b -> b.getCreativeId() != null && b.getCreativeStatusModerate() == BannerCreativeStatusModerate.NO);
    }

}
