package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class PerformanceBannerMainModerateOperationSupport implements
        BannerModerateOperationSupport<AdGroup, PerformanceBannerMain> {
    @Override
    public Class<AdGroup> getAdGroupClass() {
        return AdGroup.class;
    }

    @Override
    public Class<PerformanceBannerMain> getBannerClass() {
        return PerformanceBannerMain.class;
    }

    @Override
    public void moderate(AppliedChanges<AdGroup> adGroupChanges,
                         AppliedChanges<PerformanceBannerMain> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
        dynSmartModerationProcedure(adGroupChanges, options);
    }

    @Override
    public void remoderate(AppliedChanges<PerformanceBannerMain> bannerChanges,
                           @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);
    }
}
