package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.time.LocalDateTime;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.PerformanceAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusPostModerate;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class PerformanceBannerModerateOperationSupport
        implements BannerModerateOperationSupport<AdGroup, PerformanceBanner> {
    @Override
    public Class<AdGroup> getAdGroupClass() {
        return AdGroup.class;
    }

    @Override
    public Class<PerformanceBanner> getBannerClass() {
        return PerformanceBanner.class;
    }

    @Override
    public void moderate(AppliedChanges<AdGroup> adGroupChanges,
                         AppliedChanges<PerformanceBanner> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
        dynSmartModerationProcedure(adGroupChanges, options);

        PerformanceBanner banner = bannerChanges.getModel();
        boolean isChangedModerated = banner.getStatusModerate() == BannerStatusModerate.YES &&
                bannerChanges.changed(PerformanceBanner.STATUS_MODERATE);
        boolean isCorrectBannerStatus = banner.getStatusModerate() == BannerStatusModerate.YES ||
                banner.getStatusModerate() == BannerStatusModerate.NEW;
        if (isChangedModerated || !isCorrectBannerStatus) {
            bannerChanges.modify(PerformanceBanner.STATUS_MODERATE, BannerStatusModerate.YES);
            bannerChanges.modify(PerformanceBanner.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.YES);
            bannerChanges.modify(PerformanceBanner.STATUS_POST_MODERATE, BannerStatusPostModerate.YES);
            bannerChanges.modify(PerformanceBanner.LAST_CHANGE, LocalDateTime.now());
            bannerChanges.modify(PerformanceBanner.STATUS_BS_SYNCED, StatusBsSynced.NO);

            if (adGroupChanges.getPropertiesForUpdate().contains(PerformanceAdGroup.STATUS_MODERATE)) {
                adGroupChanges.modify(PerformanceAdGroup.STATUS_MODERATE,
                        ru.yandex.direct.core.entity.adgroup.model.StatusModerate.YES);
                adGroupChanges.modify(PerformanceAdGroup.STATUS_POST_MODERATE,
                        ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate.YES);
                adGroupChanges.modify(PerformanceAdGroup.LAST_CHANGE, LocalDateTime.now());
                adGroupChanges.modify(PerformanceAdGroup.STATUS_BS_SYNCED, StatusBsSynced.NO);
            }
        }
    }

    @Override
    public void remoderate(AppliedChanges<PerformanceBanner> bannerChanges,
                           @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);
    }
}
