package ru.yandex.direct.core.entity.banner.service.moderation.type;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerCreativeStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateOptions;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.moderation.repository.sending.remoderation.RemoderationType;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class TextBannerModerateOperationSupport implements BannerModerateOperationSupport<TextAdGroup, TextBanner> {
    @Override
    public Class<TextAdGroup> getAdGroupClass() {
        return TextAdGroup.class;
    }

    @Override
    public Class<TextBanner> getBannerClass() {
        return TextBanner.class;
    }

    @Override
    public void moderate(AppliedChanges<TextAdGroup> adGroupChanges,
                         AppliedChanges<TextBanner> bannerChanges,
                         @Nullable AppliedChanges<Creative> creativeChanges,
                         BannerModerateOptions options) {
        commonModerationProcedure(adGroupChanges, bannerChanges, options);
        bannerChanges.modifyIf(BannerWithCreative.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY,
                BannerWithCreative.class,
                b -> b.getCreativeId() != null
                        && (!options.getFilterSendingAndSent()
                        || b.getCreativeStatusModerate() == BannerCreativeStatusModerate.SENT
                        || b.getCreativeStatusModerate() == BannerCreativeStatusModerate.SENDING));
    }

    @Override
    public void remoderate(AppliedChanges<TextBanner> bannerChanges,
                           @Nullable AppliedChanges<Creative> creativeChanges,
                           Set<RemoderationType> remoderationTypes) {
        commonRemoderationProcedure(bannerChanges, remoderationTypes);

        bannerChanges.modifyIf(BannerWithCreative.CREATIVE_STATUS_MODERATE, BannerCreativeStatusModerate.READY,
                BannerWithCreative.class,
                b -> b.getCreativeId() != null && b.getCreativeStatusModerate() == BannerCreativeStatusModerate.NO);
    }

}
