package ru.yandex.direct.core.entity.banner.service.old;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.BannerTurboAppType;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerPrice;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithTurboLanding;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;

import static com.google.common.base.Preconditions.checkState;
import static java.util.stream.Collectors.toSet;
import static ru.yandex.direct.core.entity.banner.model.BannerTurboAppType.FEATURE;
import static ru.yandex.direct.core.entity.banner.model.BannerTurboAppType.OFFER;
import static ru.yandex.direct.core.entity.banner.model.old.OldBannerSimple.STATUS_MODERATE;
import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefUtils.HREF_HAS_COEF_GOAL_CONTEXT_ID;
import static ru.yandex.direct.dbutil.SqlUtils.ID_NOT_SET;

@Deprecated
public class BannerUtils {

    public static final Set<ModelProperty<? super OldBanner, ?>> SENSITIVE_PROPERTIES =
            ImmutableSet.of(
                    OldBanner.STATUS_BS_SYNCED, STATUS_MODERATE, OldBanner.STATUS_POST_MODERATE,
                    OldBanner.STATUS_SHOW, OldBanner.STATUS_ACTIVE, OldBanner.STATUS_ARCHIVED);

    public static final Set<ModelProperty<?, ?>> SENSITIVE_PROPERTIES_UNBOUNDED = ImmutableSet.copyOf(
            SENSITIVE_PROPERTIES);

    public static final List<OldBannerStatusModerate> BANNER_TO_MODERATE_STATUSES =
            ImmutableList.of(OldBannerStatusModerate.SENDING, OldBannerStatusModerate.SENT, OldBannerStatusModerate.NO);

    private static final Pattern HAS_COEF_GOAL_CONTEXT_ID_HREF = Pattern.compile("\\{coef_goal_context_id}");
    private static final Pattern HAS_PHRASEID_HREF =
            Pattern.compile("\\{(phrase_id|phraseid|param127|retargeting_id)}");

    public static final Predicate<OldBanner> BANNER_HAS_PHRASEID_HREF =
            banner -> banner.getHref() != null && HAS_PHRASEID_HREF.matcher(banner.getHref()).find();

    private BannerUtils() {
        // no instantiation
    }

    /**
     * Получить id групп, которые нужно переотправить в БК при обновлении или добавлении объявлений
     *
     * @param banners - коллекция баннеров
     * @return - номера групп для переотправки
     */
    public static Set<Long> getAdgroupsToResendBsOnAdd(Collection<? extends OldBanner> banners) {
        return banners.stream()
                .filter(BannerUtils::shouldResendAdgroupToBs)
                .map(OldBanner::getAdGroupId)
                .collect(toSet());
    }

    /**
     * Нужно ли переотправить группу, которой принадлежит этот баннер, в БК
     *
     * @param banner banner
     * @return should resend
     */
    private static boolean shouldResendAdgroupToBs(OldBanner banner) {
        return banner.getHref() != null && HREF_HAS_COEF_GOAL_CONTEXT_ID.test(banner.getHref());
    }

    /**
     * Получить id групп, которые нужно переотправить в БК при обновлении или добавлении объявлений
     *
     * @param changes - коллекция применённых к баннерам изменений
     * @return - номера групп для переотправки
     */
    public static Set<Long> getAdgroupsToResendBsOnUpdate(Collection<AppliedChanges<OldBanner>> changes) {
        return changes.stream()
                .filter(BannerUtils::shouldResendAdgroupToBs)
                .map(ac -> ac.getModel().getAdGroupId())
                .collect(toSet());
    }

    /**
     * Нужно ли переотправить группу, которой принадлежит этот баннер, в БК
     *
     * @param changes применённые к баннеру изменения
     * @return should resend
     */
    private static boolean shouldResendAdgroupToBs(AppliedChanges<OldBanner> changes) {
        OldBanner banner = changes.getModel();
        if (changes.changedAndNotDeleted(OldBanner.HREF) && HREF_HAS_COEF_GOAL_CONTEXT_ID.test(banner.getHref())) {
            return true;
        }
        if (banner instanceof OldBannerWithBannerImage) {
            return cast(changes, OldBannerWithBannerImage.class).assigned(OldBannerWithBannerImage.BANNER_IMAGE);
        }
        return false;
    }

    /**
     * Получить id performance групп, которые нужно переотправить в БК при обновлении объявлений
     * для performance: баннер изменился, но ни разу не отправлялся в БК - препосылка условия показа
     * (DIRECT-91349)
     *
     * @param changes - коллекция применённых к баннерам изменений
     * @return - номера групп для переотправки
     */
    public static <B extends OldBanner> Set<Long> getPerformanceAdgroupsToResendBsOnUpdate(
            Collection<? extends AppliedChanges<? extends B>> changes) {
        return StreamEx.of(changes)
                .filter(AppliedChanges::hasActuallyChangedProps)
                .map(AppliedChanges::getModel)
                .filter(BannerUtils::bannerNeverSentToBs)
                .map(OldBanner::getAdGroupId)
                .toSet();
    }

    /**
     * Возвращает true если баннер не разу не отправлялся в БК.
     */
    public static boolean bannerNeverSentToBs(OldBanner banner) {
        return Objects.equals(banner.getBsBannerId(), ID_NOT_SET);
    }

    @SuppressWarnings("unchecked")
    private static <B extends OldBanner> AppliedChanges<B> cast(AppliedChanges<? super B> ac, Class<B> type) {
        checkState(type.isAssignableFrom(ac.getModel().getClass()), "wrong type for casting");
        return (AppliedChanges) ac;
    }

    public static <B extends OldBannerWithTurboLanding> boolean isBannerTurbolandingChanged(
            AppliedChanges<B> appliedChanges) {
        Long newValue = appliedChanges.getNewValue(B.TURBO_LANDING_ID);
        Long oldValue = appliedChanges.getOldValue(B.TURBO_LANDING_ID);
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return appliedChanges.changed(B.TURBO_LANDING_ID);
    }

    public static <T extends OldBannerWithTurboLanding> boolean isBannerTurbolandingStatusModerateChanged(
            AppliedChanges<T> bannerChanges) {
        Long oldValue = bannerChanges.getOldValue(T.TURBO_LANDING_ID);
        Long newValue = bannerChanges.getNewValue(T.TURBO_LANDING_ID);
        return oldValue != null &&
                newValue != null &&
                bannerChanges.changed(T.TURBO_LANDING_STATUS_MODERATE) &&
                bannerChanges.getNewValue(T.TURBO_LANDING_STATUS_MODERATE) != null;
    }

    public static boolean bannerBecameDraft(AppliedChanges<? extends OldBanner> bannerChanges) {
        return bannerChanges.getNewValue(STATUS_MODERATE) == OldBannerStatusModerate.NEW;
    }

    public static boolean bannerWasDraft(AppliedChanges<? extends OldBanner> bannerChanges) {
        return bannerChanges.getOldValue(STATUS_MODERATE) == OldBannerStatusModerate.NEW;
    }

    public static boolean bannerIsOnModeration(OldBanner banner) {
        return banner.getStatusModerate() == OldBannerStatusModerate.READY;
    }

    public static boolean moderateUnconditionally(AppliedChanges<? extends OldBanner> bannerChanges) {
        return bannerWasDraft(bannerChanges) && !bannerBecameDraft(bannerChanges);
    }

    @SuppressWarnings("unchecked")
    public static <B extends OldBanner> List<ModelChanges<OldBanner>> castToBannerModelChanges(List<ModelChanges<B>> mc) {
        return (List<ModelChanges<OldBanner>>) (List<?>) mc;
    }

    public static BannerTurboAppType countBannerTurboAppType(@Nullable OldBannerPrice price) {
        return price != null ? OFFER : FEATURE;
    }
}
