package ru.yandex.direct.core.entity.banner.service.relationship;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.banner.model.BannerLinkedToBannerImageFormat;
import ru.yandex.direct.core.entity.banner.type.image.BannerImageRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Service
@ParametersAreNonnullByDefault
public class BannerLinkedToBannerImageFormatService
        implements RelationshipService<BannerLinkedToBannerImageFormat, String, Long> {
    private final ShardHelper shardHelper;
    private final BannerImageRepository bannerImageRepository;

    public BannerLinkedToBannerImageFormatService(ShardHelper shardHelper,
                                                  BannerImageRepository bannerImageRepository) {
        this.shardHelper = shardHelper;
        this.bannerImageRepository = bannerImageRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<String> parentIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return bannerImageRepository.getBidsByImageHash(shard, parentIds, clientId.asLong());
    }
}
