package ru.yandex.direct.core.entity.banner.service.relationship;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.banner.model.BannerLinkedToSitelinkSet;
import ru.yandex.direct.core.entity.banner.type.sitelink.BannerSitelinksRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между баннерами и наборами быстрых ссылок, позволяет по наборам быстрых ссылок получать привязанные к
 * ним баннеры.
 */
@ParametersAreNonnullByDefault
@Service
public class BannerLinkedToSitelinkSetService
        implements RelationshipService<BannerLinkedToSitelinkSet, Long, Long> {
    private final BannerSitelinksRepository bannerSitelinksRepository;
    private final ShardHelper helper;

    @Autowired
    public BannerLinkedToSitelinkSetService(BannerSitelinksRepository bannerSitelinksRepository,
                                            ShardHelper helper) {
        this.bannerSitelinksRepository = bannerSitelinksRepository;
        this.helper = helper;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> sitelinkSetIds) {
        var shard = helper.getShardByClientIdStrictly(clientId);
        return StreamEx.of(bannerSitelinksRepository.getBannerIdsBySitelinkSetIds(shard, sitelinkSetIds).values())
                .flatMap(Collection::stream)
                .toSet();
    }
}
