package ru.yandex.direct.core.entity.banner.service.relationship;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.banner.model.BannerLinkedToVcard;
import ru.yandex.direct.core.entity.banner.type.vcard.BannerVcardRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между баннерами и визитками, позволяет по визиткам получать привязанные к ним баннеры.
 */
@ParametersAreNonnullByDefault
@Service
public class BannerLinkedToVcardService implements RelationshipService<BannerLinkedToVcard, Long, Long> {
    private final BannerVcardRepository bannerVcardRepository;
    private final ShardHelper helper;

    @Autowired
    public BannerLinkedToVcardService(BannerVcardRepository bannerVcardRepository, ShardHelper helper) {
        this.bannerVcardRepository = bannerVcardRepository;
        this.helper = helper;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> vcardIds) {
        var shard = helper.getShardByClientIdStrictly(clientId);
        return StreamEx.of(bannerVcardRepository.getBannerIdsByVcardIds(shard, vcardIds).values())
                .flatMap(Collection::stream)
                .toSet();
    }
}
