package ru.yandex.direct.core.entity.banner.service.text;

import java.util.Collection;
import java.util.IdentityHashMap;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithBody;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedBody;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedTitle;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitle;
import ru.yandex.direct.core.entity.banner.model.BannerWithTitleExtension;

import static java.util.Arrays.asList;
import static ru.yandex.direct.core.entity.banner.service.text.FunctionTextExtractor.functionTextExtractor;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class BannerTextExtractor {

    private final CompoundTextExtractor compoundTextExtractor;

    public BannerTextExtractor() {
        this.compoundTextExtractor = new CompoundTextExtractor(asList(
                functionTextExtractor(BannerWithTitle.class, BannerWithFixedTitle.class,
                        BannerWithTitle::getTitle),
                functionTextExtractor(BannerWithTitleExtension.class,
                        BannerWithTitleExtension::getTitleExtension),
                functionTextExtractor(BannerWithBody.class, BannerWithFixedBody.class,
                        BannerWithBody::getBody)
        ));
    }

    public Collection<Class<? extends Banner>> getExtractorClasses() {
        return mapList(compoundTextExtractor.getClasses(), clazz -> (Class<? extends Banner>) clazz);
    }

    public <T extends Banner> IdentityHashMap<T, String> extractTexts(Collection<T> banners) {
        return compoundTextExtractor.extractTexts(banners);
    }
}
