package ru.yandex.direct.core.entity.banner.service.text;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.function.Function;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import static java.util.function.Function.identity;

public class FunctionTextExtractor<T> implements TextExtractor<T> {

    private final Class<T> clazz;
    private final Class<?> stopClazz;
    private final Function<T, String> extractTextFunction;

    public FunctionTextExtractor(Class<T> clazz, Function<T, String> extractTextFunction) {
        this(clazz, null, extractTextFunction);
    }

    public FunctionTextExtractor(Class<T> clazz, Class<?> stopClazz, Function<T, String> extractTextFunction) {
        this.clazz = clazz;
        this.stopClazz = stopClazz;
        this.extractTextFunction = extractTextFunction;
    }

    public static <T> FunctionTextExtractor<T> functionTextExtractor(
            Class<T> clazz, Function<T, String> extractTextFn) {
        return functionTextExtractor(clazz, null, extractTextFn);
    }

    public static <T> FunctionTextExtractor<T> functionTextExtractor(
            Class<T> clazz, Class<?> stopClazz, Function<T, String> extractTextFn) {
        return new FunctionTextExtractor<>(clazz, stopClazz, extractTextFn);
    }

    @Override
    public Class<T> getSupportedType() {
        return clazz;
    }

    @Override
    @Nullable
    public Class<?> getStopType() {
        return stopClazz;
    }

    @Override
    public <X extends T> IdentityHashMap<X, String> extractTexts(Collection<X> objects) {
        return StreamEx.of(objects)
                .mapToEntry(identity(), extractTextFunction)
                .nonNullValues()
                .toCustomMap(IdentityHashMap::new);
    }
}
