package ru.yandex.direct.core.entity.banner.service.text;

import java.util.Collection;
import java.util.IdentityHashMap;

public interface TextExtractor<T> {

    Class<T> getSupportedType();

    /**
     * Исключающий тип.
     */
    Class<?> getStopType();

    /**
     * Возвращает тексты для тех входных объектов, для которых он не равен null.
     *
     * @param objects список объектов, из которых нужно извлечь тексты
     * @param <X>     тип объектов
     * @return мапа "экземпляр объекта -> извлеченный текст"
     */
    <X extends T> IdentityHashMap<X, String> extractTexts(Collection<X> objects);
}
