package ru.yandex.direct.core.entity.banner.service.validation;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldCpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldDynamicBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldImageCreativeBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldImageHashBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldInternalBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldMcBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldMobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldPerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.old.OldTextBanner;
import ru.yandex.direct.model.ModelProperty;

public class BannerConstants {

    public static final Set<ModelProperty<?, ?>> NEW_SENSITIVE_PROPERTIES =
            ImmutableSet.of(
                    BannerWithSystemFields.STATUS_BS_SYNCED,
                    BannerWithSystemFields.STATUS_MODERATE,
                    BannerWithSystemFields.STATUS_POST_MODERATE,
                    BannerWithSystemFields.STATUS_SHOW,
                    BannerWithSystemFields.STATUS_ACTIVE,
                    BannerWithSystemFields.STATUS_ARCHIVED);

    private BannerConstants() {
    }


    public static final Map<Class<? extends OldBanner>, Class<? extends Banner>> OLD_BANNER_TO_NEW_BANNER_CLASS =
            ImmutableMap.<Class<? extends OldBanner>, Class<? extends Banner>>builder()
                    .put(OldTextBanner.class, TextBanner.class)
                    .put(OldCpcVideoBanner.class, CpcVideoBanner.class)
                    .put(OldCpmBanner.class, CpmBanner.class)
                    .put(OldMobileAppBanner.class, MobileAppBanner.class)
                    .put(OldImageHashBanner.class, ImageBanner.class)
                    .put(OldImageCreativeBanner.class, ImageBanner.class)
                    .put(OldCpmAudioBanner.class, CpmAudioBanner.class)
                    .put(OldCpmGeoPinBanner.class, CpmGeoPinBanner.class)
                    .put(OldPerformanceBanner.class, PerformanceBanner.class)
                    .put(OldCpmOutdoorBanner.class, CpmOutdoorBanner.class)
                    .put(OldCpmIndoorBanner.class, CpmIndoorBanner.class)
                    .put(OldContentPromotionBanner.class, ContentPromotionBanner.class)
                    .put(OldDynamicBanner.class, DynamicBanner.class)
                    .put(OldInternalBanner.class, InternalBanner.class)
                    .put(OldMcBanner.class, McBanner.class)
                    .build();


    /**
     * Регулярка для поиска старой шаблонной метки в тексте баннера
     */
    public static final String TEMPLATE_LABEL_OLD_RE = "\\*(шаблон)\\*";

    /**
     * Максимальное кол-во баннеров в одной группе
     */
    public static final Integer MAX_BANNERS_IN_ADGROUP = 50;

    /**
     * Максимальное кол-во баннеров в одной группе типа internal
     */
    public static final Integer MAX_BANNERS_IN_INTERNAL_ADGROUP = 1000;

    /**
     * Максимальное кол-во баннеров в одной группе uac кампании
     */
    public static final Integer DEFAULT_MAX_BANNERS_IN_UAC_ADGROUP = 500;

    /**
     * Максимальное кол-во баннеров в одной группе uc ТГО кампании
     */
    public static final Integer DEFAULT_MAX_BANNERS_IN_UAC_TEXT_ADGROUP = 500;

    /**
     * Максимальное кол-во баннеров в одной кампании типа internal
     */
    public static final Integer MAX_BANNERS_IN_INTERNAL_CAMPAIGN = 50000;

    /**
     * Максимальное кол-во баннеров в одной uac кампании
     */
    public static final Integer MAX_BANNERS_IN_UNIVERSAL_APP_CAMPAIGN = 50000;

    /**
     * Максимальное кол-во баннеров по каталогам в одной uac кампании
     */
    public static final Integer MAX_BANNERS_BY_LISTINGS = 50;
}
