package ru.yandex.direct.core.entity.banner.service.validation;

import java.util.regex.Pattern;

import static ru.yandex.direct.utils.TextConstants.ALL;
import static ru.yandex.direct.utils.TextConstants.SPECIAL_CHARS;

public class BannerLettersConstants {

    private BannerLettersConstants() {
    }

    /**
     * Символы, доступные в баннерах
     */
    public static final String ALLOW_BANNER_LETTERS_STR = ALL + SPECIAL_CHARS;

    /**
     * Регулярка, проверяющая символ на доступность в баннере
     */
    public static final String ALLOW_BANNER_LETTERS_RE = "[" + Pattern.quote(ALLOW_BANNER_LETTERS_STR) + "]";

    /**
     * Регулярка, проверяющая недоступность символа в баннере
     */
    public static final String NOT_ALLOW_BANNER_LETTERS_RE = "[^" + Pattern.quote(ALLOW_BANNER_LETTERS_STR) + "]";

    /**
     * Регулярка для поиска шаблонной метки в тексте баннера
     */
    public static final String TEMPLATE_LABEL_RE =
            BannerTextConstants.TEMPLATE_MARKER_SYMBOL + "(" + ALLOW_BANNER_LETTERS_RE + "*?)" + BannerTextConstants.TEMPLATE_MARKER_SYMBOL;

    public static final Pattern TEMPLATE_PATTERN = Pattern.compile(TEMPLATE_LABEL_RE);
}
