package ru.yandex.direct.core.entity.banner.service.validation;

import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.validation.constraint.StringConstraints.notContains;

@ParametersAreNonnullByDefault
public class BannerUriConstraints {

    private static final Pattern INVALID_ESCAPE_SEQ = Pattern.compile("(?:%.?(?:[^0-9a-fA-F]|$))");

    public static Constraint<String, Defect> hasNotInvalidEscapeSeq() {
        return notContains(INVALID_ESCAPE_SEQ);
    }

}
