package ru.yandex.direct.core.entity.banner.service.validation;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;

/**
 * Класс, хранящий информацию для валидации баннера, в том числе приходящую из комплексной операции и ещё не сохранённую в базе
 * Затем может дозаполняться в процессе валидации
 */
public class BannerValidationInfo {
    private Boolean cpmAdGroupWithKeywords;
    //retargetingConditions инициализируется только при обновлении RetargetingCondition
    //retargetingConditions и retargetingConditionIds не могут быть одновременно отличны от null
    private List<RetargetingCondition> retargetingConditions;
    private List<Long> retargetingConditionIds;
    private Long campaignId;
    private AdGroupType adGroupType;

    public BannerValidationInfo(List<Keyword> keywords, List<Long> retargetingConditionIds, Long campaignId,
                                List<RetargetingCondition> retargetingConditions, AdGroupType adGroupType) {
        this.cpmAdGroupWithKeywords = (keywords == null ? null : !keywords.isEmpty());
        this.retargetingConditions = retargetingConditions;
        this.retargetingConditionIds = retargetingConditionIds;
        this.campaignId = campaignId;
        this.adGroupType = adGroupType;
    }

    public BannerValidationInfo(List<Keyword> keywords, List<Long> retargetingConditionIds) {
        this(keywords, retargetingConditionIds, null, null, null);
    }

    public Boolean getCpmAdGroupWithKeywords() {
        return cpmAdGroupWithKeywords;
    }

    public void setCpmAdGroupWithKeywords(Boolean cpmAdGroupWithKeywords) {
        this.cpmAdGroupWithKeywords = cpmAdGroupWithKeywords;
    }

    public List<Long> getRetConditionIds() {
        return retargetingConditionIds;
    }

    public void setRetConditionIds(List<Long> retargetingConditionIds) {
        this.retargetingConditionIds = retargetingConditionIds;
    }

    public List<RetargetingCondition> getRetargetingConditions() {
        return retargetingConditions;
    }

    public void setRetargetingConditions(
            List<RetargetingCondition> retargetingConditions) {
        this.retargetingConditions = retargetingConditions;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Long campaignId) {
        this.campaignId = campaignId;
    }

    public AdGroupType getAdGroupType() {
        return adGroupType;
    }

    public void setAdGroupType(AdGroupType adGroupType) {
        this.adGroupType = adGroupType;
    }
}
