package ru.yandex.direct.core.entity.banner.service.validation;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.model.TextBanner;

import static com.google.common.collect.Multimaps.invertFrom;
import static com.google.common.collect.Multimaps.unmodifiableSetMultimap;

/**
 * Соответствие типов объявлений и групп объявлений.
 */
@ParametersAreNonnullByDefault
public class BannersAdGroupsTypes {
    private static final SetMultimap<Class, AdGroupType> bannersToAdGroups = createBannersToAdGroups();

    private static final SetMultimap<AdGroupType, Class> adGroupToBanner = unmodifiableSetMultimap(
            invertFrom(bannersToAdGroups, HashMultimap.create()));

    @SuppressWarnings("unused")
    public static Set<Class> getCorrespondingBannerClasses(AdGroupType adGroupType) {
        return new HashSet<>(adGroupToBanner.get(adGroupType));
    }

    @SuppressWarnings("unused")
    public static Set<AdGroupType> getCorrespondingAdGroupTypes(Class bannerClass) {
        return new HashSet<>(bannersToAdGroups.get(bannerClass));
    }

    public static boolean isValidPair(Class bannerClass, AdGroupType adGroupType) {
        return getCorrespondingAdGroupTypes(bannerClass).contains(adGroupType);
    }

    private static SetMultimap<Class, AdGroupType> createBannersToAdGroups() {
        SetMultimap<Class, AdGroupType> multimap = HashMultimap.create();
        multimap.put(TextBanner.class, AdGroupType.BASE);
        multimap.put(CpcVideoBanner.class, AdGroupType.BASE);
        multimap.put(CpcVideoBanner.class, AdGroupType.MOBILE_CONTENT);
        multimap.put(ImageBanner.class, AdGroupType.BASE);
        multimap.put(ImageBanner.class, AdGroupType.MOBILE_CONTENT);
        multimap.put(MobileAppBanner.class, AdGroupType.MOBILE_CONTENT);
        multimap.put(DynamicBanner.class, AdGroupType.DYNAMIC);
        multimap.put(DynamicBanner.class, AdGroupType.BASE);
        multimap.put(McBanner.class, AdGroupType.MCBANNER);
        multimap.put(CpmBanner.class, AdGroupType.CPM_BANNER);
        multimap.put(PerformanceBanner.class, AdGroupType.PERFORMANCE);
        multimap.put(PerformanceBanner.class, AdGroupType.BASE);
        multimap.put(PerformanceBannerMain.class, AdGroupType.PERFORMANCE);
        multimap.put(PerformanceBannerMain.class, AdGroupType.BASE);
        multimap.put(InternalBanner.class, AdGroupType.INTERNAL);
        multimap.put(CpmBanner.class, AdGroupType.CPM_VIDEO);
        multimap.put(CpmOutdoorBanner.class, AdGroupType.CPM_OUTDOOR);
        multimap.put(CpmIndoorBanner.class, AdGroupType.CPM_INDOOR);
        multimap.put(CpmAudioBanner.class, AdGroupType.CPM_AUDIO);
        multimap.put(CpmBanner.class, AdGroupType.CPM_YNDX_FRONTPAGE);
        multimap.put(CpmBanner.class, AdGroupType.CPM_GEOPRODUCT);
        multimap.put(CpmGeoPinBanner.class, AdGroupType.CPM_GEO_PIN);
        multimap.put(ContentPromotionBanner.class, AdGroupType.CONTENT_PROMOTION);
        return Multimaps.unmodifiableSetMultimap(multimap);
    }

    private BannersAdGroupsTypes() {
    }
}
