package ru.yandex.direct.core.entity.banner.service.validation.defects;

import ru.yandex.direct.core.validation.defects.params.CollectionValuesDefectParams;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.queryrec.model.Language;
import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class BannerDefectIds {

    public enum Gen implements DefectId<Void> {
        ACTION_IN_ARCHIVED_CAMPAIGN,
        AD_GROUP_NOT_FOUND,
        AD_GROUP_TYPE_NOT_SUPPORTED,
        AD_MORE_THAN_ONCE_IN_REQUEST,
        AD_NOT_FOUND,
        ADD_TO_ARCHIVED_CAMPAIGN_NOT_ALLOWED,
        ALREADY_ARCHIVED,
        ARCHIVE_BANNER_SHOWN_IN_BS,
        ARCHIVE_DRAFT_BANNER,
        ALREADY_SUSPENDED,
        ARCHIVED_BANNER_MODIFICATION,
        ARRAY_ELEMENT_INVALID_ID,
        BANNER_MODERATE_WITH_EMPTY_GROUP,
        BANNER_TYPE_MODIFICATION,
        CANNOT_CHANGE_BANNER_FLAGS_FROM_AGE_TO_OTHER_TYPES,
        CANNOT_CHANGE_BANNER_FLAGS_FROM_BABY_FOOD_TO_OTHER_TYPES,
        CANNOT_UPDATE_ARCHIVED_AD,
        CLIENT_CANNOT_SET_BANNER_FLAGS,
        CLIENT_HAS_NOT_CREATIVES,
        CREATIVE_NOT_FOUND,
        DUPLICATE_SPECIAL_CHARS_IN_DISPLAY_HREF,
        EMPTY_DISPLAY_HREF,
        EMPTY_HREF,
        EMPTY_VALUE,
        FORBIDDEN_MOBILE_BANNER,
        ILLEGAL_COMMA,
        IMAGE_NOT_FOUND,
        IMAGE_SIZE_MODIFICATION,
        IMAGE_SIZE_NOT_FOUND,
        IMAGE_SIZE_INVALID,
        INCONSISTENT_BANNER_CID_AND_CAMPAIGN_ID,
        INCONSISTENT_BANNER_TYPE,
        INCONSISTENT_STATE_BANNER_TYPE_AND_ADGROUP_TYPE,
        INCONSISTENT_STATE_BANNER_TYPE_AND_IMAGE_TYPE,
        INCONSISTENT_STATE_BANNER_TYPE_AND_TURBOLANDING_TYPE,
        INSUFFICIENT_RIGHTS,
        INVALID_DISPLAY_HREF_USAGE,
        // сделано отдельно, т.к. отличаются detail message,
        INVALID_HREF,
        INVALID_DOMAIN,
        INVALID_SITELINK_SET_USAGE,
        SITELINK_DOMAIN_IS_NOT_FIT_TO_BANNER,
        INVALID_TEMPLATE_QUERY,
        CANNOT_HAVE_TEMPLATE,
        IS_NOT_ARCHIVED,
        IS_NOT_SUSPENDED,
        REQUIRED_HREF_OR_VCARD_ID,
        REQUIRED_HREF_OR_TURBOLANDING_ID,
        REQUIRED_IMAGE_HASH_OR_CREATIVE_ID,
        REQUIRED_ONLY_IMAGE_OR_CREATIVE_ID,
        CANNOT_CHANGE_IMAGE_TO_CREATIVE_ID,
        CANNOT_CHANGE_CREATIVE_ID_TO_IMAGE,
        BANNER_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY,
        BANNER_SITELINKS_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY,
        REQUIRED_VIDEO_ADDITION_TYPE_ONLY,
        REQUIRED_CPM_VIDEO_TYPE_ONLY,
        INCONSISTENT_CREATIVE_AND_CPM_VIDEO_AD_GROUP_SKIPPABILITY,
        REQUIRED_CPM_AUDIO_TYPE_ONLY,
        REQUIRED_HTML5_TYPE_ONLY,
        REQUIRED_CANVAS_OR_HTML5_TYPES,
        REQUIRED_CANVAS_TYPE_ONLY,
        RESTRICTED_CHARS_IN_FIELD,
        RESUME_ARCHIVED_BANNER,
        RESUME_DRAFT_BANNER,
        SITELINKS_SET_NOT_FOUND,
        TURBO_PAGE_NOT_FOUND,
        SUSPEND_ARCHIVED_BANNER,
        SUSPEND_DRAFT_BANNER,
        THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
        THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS,
        TRACKING_URL_DOESNT_CONTAIN_MACROS,
        UNSUPPORTED_BANNER_TYPE,
        UNSUPPORTED_BUTTON_ACTION,
        VCARD_NOT_FOUND,
        VCARD_OF_ANOTHER_CAMPAIGN,
        VIDEO_EXTENSION_NOT_FOUND,
        CPC_VIDEO_NOT_FOUND,
        UNABLE_TO_DELETE,
        INCONSISTENT_CREATIVE_TYPE_TO_BANNER_TYPE,
        INCONSISTENT_CREATIVE_BUSINESS_TYPE_TO_FEED_BUSINESS_TYPE,
        INCONSISTENT_CREATIVE_GEO_TO_ADGROUP_GEO,
        INCONSISTENT_CREATIVE_FORMAT,
        MODERATE_BANNER_IN_GROUP_WITHOUT_SHOW_CONDITIONS,
        MODERATE_ARCHIVED_BANNER,
        MODERATE_NON_DRAFT_BANNER,
        REMODERATE_DRAFT_BANNER,
        INVALID_PIXEL_FORMAT,
        CANNOT_HAVE_TURBOLANDINGS,
        CONTENT_TYPE_NOT_MATCHES_ADGROUP_CONTENT_TYPE,
        CONTENT_PROMOTION_VIDEO_IS_INACCESSIBLE,
        CONTENT_PROMOTION_COLLECTION_IS_INACCESSIBLE,
        BANNER_PRICE_MISSING,
        BANNER_PRICE_CURRENCY_MISSING,
        BANNER_PRICE_GREATER_THAN_OLD,
        BANNER_CANNOT_HAVE_TURBO_GALLERY_HREF,
        FORBIDDEN_TO_CHANGE,
        INTERNAL_TEMPLATE_NOT_ALLOWED,
        INTERNAL_TEMPLATE_VARIABLES_MISMATCH,
        REQUIRED_CAMPAIGNS_IMPRESSION_RATE_BUT_EMPTY,
        REQUIRED_AD_GROUPS_IMPRESSION_RATE_BUT_EMPTY,
        REQUIRED_CAMPAIGN_OR_AD_GROUP_MAX_STOPS_COUNT_BUT_EMPTY,
        PRICE_SALES_FULLNESS_VIOLATED,
        PRICE_SALES_CAMPAIGN_GEO_OVERLAPS_BANNER_MINUS_GEO,
        PRICE_SALES_DISALLOWED_CREATIVE_TEMPLATE,
        REMODERATE_BANNER_IS_NOT_ALLOWED,
        REMODERATE_BANNER_WITH_NO_MOD_REASONS,
        ERRORS_WHILE_COPYING_BANNERS,
        INCONSISTENT_LEADFORM_HREF_AND_BUTTON_TEXT,
        DIFFERENT_TEMPLATES_NOT_ALLOWED,
        TEMPLATE_RESOURCE_ID_NOT_FOUND,
        TEMPLATE_MUST_BE_MODERATED,
        INCORRECT_IMPRESSION_URL_TRACKING_SYSTEM,
        INCORRECT_IMPRESSION_URL_TRACKER_ID,
    }

    public enum Num implements DefectId<NumberDefectParams> {
        MAX_BANNERS_IN_ADGROUP,
        MAX_BANNERS_IN_INTERNAL_CAMPAIGN,
        MAX_BANNERS_IN_UNIVERSAL_APP_CAMPAIGN,
    }

    public enum Size implements DefectId<CollectionSizeDefectParams> {
        MAX_CALLOUTS_PER_BANNER,
        MAX_CALLOUTS_ON_BANNER_ADD,
        MAX_YA_AUD_PIXELS_ON_BANNER,
        MAX_FOREIGN_PIXELS_ON_BANNER
    }

    public enum String implements DefectId<StringDefectParams> {
        DISPLAY_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
        HREF_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
        LENGTH_WORD_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
        MAX_NUMBER_OF_NARROW_CHARACTERS_CANNOT_BE_MORE_THAN_MAX,
        RESTRICTED_CHARS_IN_DISPLAY_HREF,
        SHOULD_NOT_BE_BLANK,
        TEXT_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
        NO_RIGHTS_TO_AUDIENCE_PIXEL,
        INVALID_SPEC_SYMBOL,
    }

    public enum PixelWithMeasurer implements DefectId<PixelWithMeasurerDefectParams> {
        INVALID_PIXEL_WITH_MEASURER,
    }

    public enum PixelPermissions implements DefectId<PixelPermissionsDefectParams> {
        NO_RIGHTS_TO_PIXEL,
    }

    public enum PixelProviderLimits implements DefectId<PixelProvidersLimitsDefectParams> {
        EQUAL_PIXEL_PROVIDERS,
    }

    public enum LanguageDefect implements DefectId<Language> {
        INCONSISTENT_LANGUAGE_WITH_GEO
    }

    public enum Id implements DefectId<ModelIdDefectParams> {
        AD_EXTENSION_NOT_FOUND,
        ARCHIVE_IN_ARCHIVED_CAMPAIGN,
        DUPLICATED_AD_EXTENSION_ID,
        UNARCHIVE_IN_ARCHIVED_CAMPAIGN,
        RESUME_IN_ARCHIVED_CAMPAIGN,
        SUSPEND_IN_ARCHIVED_CAMPAIGN,
        REMODERATE_BANNER_IN_DRAFT_CAMPAIGN,
        MODERATE_BANNER_IN_ARCHIVED_CAMPAIGN,
        ;
    }

    public enum Price implements DefectId<NumberDefectParams> {
        MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
        MUST_BE_GREATER_THAN_MIN,
        ;
    }

    public enum ModReasons implements DefectId<CollectionValuesDefectParams<Long>> {
        REMODERATE_BANNER_WITH_NOT_ALLOWED_MOD_REASONS
    }
}
