package ru.yandex.direct.core.entity.banner.service.validation.defects;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.result.Path;

@SuppressWarnings("squid:S1214")
public interface BannerDefectTranslations extends TranslationBundle {

    BannerDefectTranslations INSTANCE = I18NBundle.implement(BannerDefectTranslations.class);

    @MessageFormatStub("Максимальная длина ({0}) ссылки превышена")
    Translatable maxHrefLengthDetailed(Identity maxLength);

    @MessageFormatStub("В поле {0} недопустимы слова длиной более {1} знаков: \"{2}\"")
    Translatable maxWordLengthDetailed(Path path, Identity maxLength, String word);

    @MessageFormatStub("Неправильное использование знаков препинания в поле {0}")
    Translatable improperUseOfPunctuationMarks(Path path);

    @MessageFormatStub("Неправильно составлен шаблон")
    Translatable invalidTemplateQuery();

    @MessageFormatStub("В этом поле не может использоваться шаблон")
    Translatable cannotHaveTemplate();

    @MessageFormatStub("Заданы быстрые ссылки, но не указана основная ссылка в объявлении")
    Translatable inconsistentStateSitelinkSetIdWithNoHrefDetailed();

    @MessageFormatStub("Задана отображаемая ссылка, но не указана основная ссылка в объявлении")
    Translatable inconsistentStateDisplayHrefWithNoHrefDetailed();

    @MessageFormatStub("В объявлении должна быть указана визитка или основная ссылка")
    Translatable requiredOneOfHrefOrVcardIdDetailed();

    @MessageFormatStub("В объявлении должна быть указана турбо-страница или основная ссылка")
    Translatable requiredOneOfHrefOrTurbolandingIdDetailed();

    @MessageFormatStub("В объявлении должна быть указана турбо-страница")
    Translatable requiredTurbolandingIdDetailed();

    @MessageFormatStub("Разархивация баннера запрещена. Оплата за конверсии доступна для кампаний с объявлениями, ссылающимися только на турбо-страницы")
    Translatable cannotUnarchiveBannerWhenParamsIsIncompatibleWithPayForConversionStrategy();

    @MessageFormatStub("Разархивация баннера запрещена. Оплата за конверсии доступна для кампаний с быстрыми ссылками, ссылающимися только на турбо-страницы")
    Translatable cannotUnarchiveBannerWhenSitelinksParamsIsIncompatibleWithPayForConversionStrategy();

    @MessageFormatStub("Недопустимые символы в поле DisplayUrlPath: <{0}>."
            + " В поле разрешены только буквы латинского, турецкого, русского, украинского, казахского"
            + " или белорусского алфавита, цифры, символы /- № # %")
    Translatable invalidCharsDisplayHrefDetailed(String illegalSubstring);

    @MessageFormatStub("Cпецсимволы в поле DisplayUrlPath не должны повторяться")
    Translatable duplicateSpecCharsInDisplayHrefDetailed();

    @MessageFormatStub("Неправильный формат ссылки")
    Translatable invalidHrefDetailed();

    @TranslationStub("Объявление данного типа не поддерживается")
    Translatable unsupportedBannerType();

    @TranslationStub("Данное действие по кнопке не поддерживается")
    Translatable unsupportedButtonAction();

    @TranslationStub("Неверный тип объявления")
    Translatable inconsistentBannerType();

    @MessageFormatStub("Тип объявления не соответствует группе")
    Translatable inconsistentBannerTypeAndGroupTypeDetailed();

    @MessageFormatStub("Размер изображения не соответствует типу объявления")
    Translatable inconsistentStateBannerTypeAndImageSizeDetailed();

    @MessageFormatStub("Тип турбостраницы не соответствует типу баннера")
    Translatable inconsistentStateBannerTypeAndTurbolandingTypeDetailed();

    @MessageFormatStub("Запрещено обновлять объявление в заархивированной кампании")
    Translatable cannotUpdateArchivedCampaignDetailed();

    @MessageFormatStub("Запрещено добавлять объявление в заархивированную кампанию")
    Translatable addToArchivedCampaignNotAllowedDetailed();

    @TranslationStub("Запрещено обновлять заархивированное объявление")
    Translatable cannotUpdateArchivedAd();

    @MessageFormatStub("Достигнуто максимальное количество объявлений в группе - {0}")
    Translatable maxBannersInGroupDetailed(Identity maxBannersInAdgroup);

    @MessageFormatStub("Достигнуто максимальное количество объявлений внутренней рекламы в кампании - {0}")
    Translatable maxBannersInInternalCampaignDetailed(Identity maxBannersInInternalCampaign);

    @MessageFormatStub("Достигнуто максимальное количество объявлений в универсальной кампании приложений - {0}")
    Translatable maxBannersInUniversalAppCampaignDetailed(Identity maxBannersInUniversalAppCampaign);

    @MessageFormatStub("Текст объявления написан на украинском языке и не соответствует установленному региону показа."
            + " Возможен таргетинг только на Украину.")
    Translatable inconsistentLanguageWithGeoUkraineDetailed();

    @MessageFormatStub("Текст объявления написан на казахском языке и не соответствует установленному региону показа."
            + " Возможен таргетинг только на Казахстан.")
    Translatable inconsistentLanguageWithGeoKazahksanDetailed();

    @MessageFormatStub("Текст объявления написан на турецком языке и не соответствует установленному региону показа."
            + " Возможен таргетинг только на Турцию.")
    Translatable inconsistentLanguageWithGeoTurkeyDetailed();

    @MessageFormatStub("Текст объявления написан на белорусском языке и не соответствует установленному региону показа."
            + " Возможен таргетинг только на Беларусь.")
    Translatable inconsistentLanguageWithGeoBelarusDetailed();

    @MessageFormatStub("Текст объявления написан на узбекском языке и не соответствует установленному региону показа."
            + " Возможен таргетинг только на Узбекистан.")
    Translatable inconsistentLanguageWithGeoUzbekDetailed();

    @MessageFormatStub("Текст объявления написан на вьетнамском языке и не соответствует установленному региону показа."
            + " Возможен таргетинг только на Азию.")
    Translatable inconsistentLanguageWithGeoVieDetailed();

    @MessageFormatStub("В поле {0} вы можете использовать не более {1} точек, запятых, двоеточий, точек с запятой,"
            + " кавычек и восклицательных знаков")
    Translatable maxNumberOfNarrowCharactersInFieldDetailed(Path path, Identity maxLength);

    @MessageFormatStub("Недостаточно прав")
    Translatable insufficientRights();

    @MessageFormatStub("Изображение не найдено")
    Translatable imageNotFoundDetailed();

    @MessageFormatStub("Набор быстрых ссылок не найден")
    Translatable sitelinksSetNotFoundDetailed();

    @MessageFormatStub("Визитка не найдена")
    Translatable vcardNotFoundDetailed();

    @TranslationStub("Креатив не найден")
    Translatable creativeNotFound();

    @MessageFormatStub("Видеодополнение не найдено")
    Translatable videoExtNotFoundDetailed();

    @MessageFormatStub("Кликовое видео не найдено")
    Translatable cpcVideoNotFoundDetailed();

    @MessageFormatStub("Турбо-страница не найдена")
    Translatable turboPageNotFoundDetailed();

    @TranslationStub("Объявление не найдено")
    Translatable adNotFoundDetailed();

    @MessageFormatStub("Группа объявлений не найдена")
    Translatable adGroupNotFoundDetailed();

    @MessageFormatStub("Расширение {0} не найдено")
    Translatable adExtensionNotFoundDetailed(Identity id);

    @MessageFormatStub("В объявлении должна быть указана ссылка")
    Translatable emptyHrefDetailed();

    @MessageFormatStub("Данный домен трекинговой системы не поддерживается")
    Translatable trackingSystemDomainNotSupported();

    @MessageFormatStub("Данный домен трекинговой системы поддерживает только протокол https")
    Translatable trackingSystemDomainSupportsHttpsOnly();

    @MessageFormatStub("Разрешено создавать не более {0} объявлений в одном запросе")
    Translatable maxBannersPerAddRequestDetailed(Identity max);

    @MessageFormatStub("Разрешено изменять не более {0} объявлений в одном запросе")
    Translatable maxBannersPerUpdateRequestDetailed(Identity max);

    @MessageFormatStub("Разрешено возобновлять показы не более {0} объявлений в одном запросе")
    Translatable maxBannersPerResumeRequestDetailed(Identity max);

    @MessageFormatStub("Разрешено останавливать не более {0} объявлений в одном запросе")
    Translatable maxBannersPerSuspendRequestDetailed(Identity max);

    @MessageFormatStub("Разрешено удалять не более {0} объявлений в одном запросе")
    Translatable maxBannersPerDeleteRequestDetailed(Identity max);

    @MessageFormatStub("Элемент массива {0} должен быть целым положительным числом")
    Translatable invalidIdInArrayElement(Path path);

    @MessageFormatStub("Визитка не принадлежит кампании")
    Translatable vcardOfAnotherCampaignDetailed();

    @MessageFormatStub("Значение {0} не может повторяться в поле AdExtensionIds более одного раза")
    Translatable duplicatedAdExtensionIdDetailed(Identity id);

    @MessageFormatStub("Массив AdExtensionIds не может содержать более {0} элементов")
    Translatable adExtensionsLimitExceededDetailed(Identity max);

    @MessageFormatStub("К одному объявлению можно указать до {0} уточнений")
    Translatable adExtensionsPerBannerLimitExceededDetailed(Identity max);

    @MessageFormatStub("В поле {0} указано пустое значение")
    Translatable emptyValueInField(Path path);

    @TranslationStub("Размеры нового и предыдущего изображений должны быть одинаковыми")
    Translatable cannotUpdateImageSize();

    @MessageFormatStub("Разрешено архивировать не более {0} объявлений в одном запросе")
    Translatable maxBannersPerArchiveRequestDetailed(Identity max);

    @MessageFormatStub("Разрешено разархивировать не более {0} объявлений в одном запросе")
    Translatable maxBannersPerUnarchiveRequestDetailed(Identity max);

    @TranslationStub("Объявление уже заархивировано")
    Translatable alreadyArchived();

    @TranslationStub("Объявление не заархивировано")
    Translatable isNotArchived();

    @TranslationStub("Объявление показывается и не может быть заархивировано")
    Translatable cannotArchiveBannerShownInBs();

    @TranslationStub("Объявление является черновиком и не может быть заархивировано")
    Translatable cannotArchiveDraftBanner();

    @MessageFormatStub("Запрещено разархивировать объявления в заархивированной кампании {0}")
    Translatable unarchiveInArchivedCampaign(Identity id);

    @MessageFormatStub("Запрещено архивировать объявления в заархивированной кампании {0}")
    Translatable archiveInArchivedCampaign(Identity id);

    @TranslationStub("Объявление уже остановлено")
    Translatable alreadySuspended();

    @MessageFormatStub("Запрещено останавливать объявления в заархивированной кампании {0}")
    Translatable suspendBannerInArchivedCampaign(Identity campaignId);

    @MessageFormatStub("Запрещено запускать объявления в заархивированной кампании {0}")
    Translatable resumeBannerInArchivedCampaign(Identity campaignId);

    @TranslationStub("Объявление заархивировано и не может быть остановлено")
    Translatable cannotSuspendArchivedBanner();

    @TranslationStub("Объявление заархивировано и не может быть запущено")
    Translatable cannotResumeArchivedBanner();

    @TranslationStub("Объявление является черновиком и не может быть остановлено")
    Translatable cannotSuspendDraftBanner();

    @TranslationStub("Объявление является черновиком и не может быть запущено")
    Translatable cannotResumeDraftBanner();

    @TranslationStub("Объявление не остановлено")
    Translatable isNotSuspended();

    @MessageFormatStub("Для данного объявления допустимы следующие значения возрастной метки: {0}")
    Translatable onlyTheFollowingAgeLabelValuesAreAvailable(String values);

    @TranslationStub("Разрешено изменять значение только присвоенной при модерации возрастной метки")
    Translatable clientCannotSetBannerFlags();

    @TranslationStub("Нельзя указывать операцию SET c операциями ADD и REMOVE в одном запросе")
    Translatable invalidCalloutsModificationDetailed();

    @MessageFormatStub("Расширение {0} уже привязано к этому объявлению")
    Translatable warningAdExtensionAlreadyAssigned(Identity id);

    @MessageFormatStub("Расширение {0} не привязано к этому объявлению")
    Translatable warningAdExtensionIsNotAssigned(Identity id);

    @MessageFormatStub("Объявление должно содержать один из объектов {0}")
    Translatable adMustContainOneOfTheTypeObjects(String typesList);

    @MessageFormatStub("Объявление не может быть удалено")
    Translatable unableToDeleteDetailed();

    @MessageFormatStub("Id объявления присутствует в запросе более одного раза")
    Translatable adMoreThanOnceInRequest();

    @MessageFormatStub("Объявление не остановлено")
    Translatable adNotSuspendedShort();

    @MessageFormatStub("Объявление уже остановлено")
    Translatable adAlreadySuspendedShort();

    @TranslationStub("Трекинговая ссылка должна содержать макросы для отслеживания устройств ({logid}, {google_aid}, {ios_ifa})")
    Translatable trackingUrlDoesntContainMacros();

    @TranslationStub("В трекинговой ссылке отсутствует макрос {logid}, необходимый для отслеживания установок приложения")
    Translatable trackingUrlDoesntContainLogid();

    @MessageFormatStub("Неверный формат пикселя Яндекс.Аудиторий или счетчика показов")
    Translatable invalidPixelFormat();

    @MessageFormatStub("Нет прав на установку этого счетчика показов: {0}")
    Translatable noRightsToPixel(String url);

    @MessageFormatStub("Нет прав на установку этого пикселя Яндекс.Аудиторий: {0}")
    Translatable noRightsToAudiencePixel(String url);

    @MessageFormatStub("Невозможно одновременно использовать пиксель {0} и внешний измеритель {1}. Удалите одно из значений.")
    Translatable invalidPixelWithMeasurer(String url, String measurerSystemName);

    @MessageFormatStub("Объявление может содержать не более одного пикселя Яндекс.Аудиторий")
    Translatable maxYaAudiencePixelsOnBannerExceeded();

    @MessageFormatStub("Превышено максимальное количество счетчиков показа в объявлении")
    Translatable maxNonYaAudiencePixelsOnBannerExceeded();

    @MessageFormatStub("Счётчики показов следующих провайдеров указаны более одного раза: {0}")
    Translatable equalPixelProviders(String providerNamesJoined);

    @MessageFormatStub("Разрешено отправлять на модерацию не более {0} объявлений в одном запросе")
    Translatable maxBannersPerModerateRequestDetailed(Identity max);

    @MessageFormatStub("Нельзя отправить на модерацию заархивированное объявление")
    Translatable moderateArchivedBanner();

    @MessageFormatStub("Отправить на модерацию возможно только объявление в статусе DRAFT")
    Translatable moderateNonDraftBanner();

    @MessageFormatStub("Отправить на перемодерацию возможно только объявление не в статусе DRAFT")
    Translatable remoderateDraftBanner();

    @MessageFormatStub("Нельзя отправить на модерацию объявление без условий показа")
    Translatable moderateBannerInAdGroupWithoutShowConditions();

    @MessageFormatStub("Запрещено отправлять на модерацию объявления в заархивированной кампании {0}")
    Translatable moderateBannerInArchivedCampaign(Identity id);

    @MessageFormatStub("Запрещено отправлять на перемодерацию объявления в кампании-черновике {0}")
    Translatable remoderateBannerInDraftCampaign(Identity id);

    @MessageFormatStub("Перемодерация объявления не доступна")
    Translatable remoderateBannerIsNotAllowed();

    @MessageFormatStub("Объявление или его ресурсы отклонены по причинам не позволяющим отправить его на перемодерацию")
    Translatable remoderateBannerWithNotAllowedModReasons();

    @MessageFormatStub("Запрещено отправлять на переможерацию объявление, которое не было отклонено")
    Translatable remoderateBannerWithNoModReasons();

    @MessageFormatStub("Запрещено изменять outdoor баннеры")
    Translatable updatingCpmOutdoorBannerIsForbidden();

    @MessageFormatStub("Тип группы партнёрского контента не соответствует контенту")
    Translatable contentTypeNotMatchesAdGroupContentType();

    @MessageFormatStub("Видео недоступно")
    Translatable contentPromotionVideoIsInaccessible();

    @MessageFormatStub("Коллекция недоступна")
    Translatable contentPromotionCollectionIsInaccessible();

    @MessageFormatStub("Не указана цена")
    Translatable bannerPriceMissing();

    @MessageFormatStub("Не указана валюта")
    Translatable bannerPriceCurrencyMissing();

    @MessageFormatStub("Старая цена должна быть больше новой")
    Translatable bannerPriceGreaterThanOld();

    @MessageFormatStub("URL страницы с лидформой и текст кнопки открытия формы должны быть заданы вместе")
    Translatable inconsistentLeadformHrefAndButtonText();

    @MessageFormatStub("Баннер уже присутствует в группе")
    Translatable bannerInThisAdgroupAlreadyExists();

    @MessageFormatStub("Баннеры без креатива не разрешены")
    Translatable bannersWithoutCreativeNotEnabled();

    @MessageFormatStub("Создание баннеров с креативами вскоре перестанет поддерживаться. Смарт-баннеры будут автоматически показываться во всех доступных форматах. Для создания смарт-баннера не указывайте Creative в запросе. Допустимо не более одного баннера на группу.")
    Translatable bannersWithCreativeDeprecated();

    @MessageFormatStub("Логотип можно указывать только для баннеров без креатива")
    Translatable logoIsOnlyForBannersWithoutCreative();

    @MessageFormatStub("Нельзя добавить объявление в смарт-группу без креативов")
    Translatable cannotAddBannerToNoCreativeAdGroup();

    @MessageFormatStub("Трекинговая ссылка для просмотра не подходит к уже введенной выше трекинговой ссылке")
    Translatable incorrectImpressionUrlTrackingSystem();

    @MessageFormatStub("Трекинговая ссылка для просмотра имеет разный ID с уже введенной выше трекинговой ссылкой")
    Translatable incorrectImpressionUrlTrackerId();
}
