package ru.yandex.direct.core.entity.banner.service.validation.defects;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerWithCallouts;
import ru.yandex.direct.core.entity.banner.type.pixels.InventoryType;
import ru.yandex.direct.core.entity.banner.type.pixels.PixelPermissionInfo;
import ru.yandex.direct.core.entity.banner.type.pixels.PixelProvider;
import ru.yandex.direct.core.entity.banner.type.pixels.PixelUtils;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.validation.defects.params.CollectionValuesDefectParams;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.queryrec.model.Language;
import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;

import static java.util.Collections.singletonList;

public class BannerDefects {

    private BannerDefects() {
    }

    public static Defect<Void> illegalComma() {
        return new Defect<>(BannerDefectIds.Gen.ILLEGAL_COMMA);
    }

    public static Defect<Void> invalidHref() {
        return new Defect<>(BannerDefectIds.Gen.INVALID_HREF);
    }

    public static Defect<Void> invalidDomain() {
        return new Defect<>(BannerDefectIds.Gen.INVALID_DOMAIN);
    }

    public static Defect<Void> duplicateSpecCharsInDisplayHref() {
        return new Defect<>(BannerDefectIds.Gen.DUPLICATE_SPECIAL_CHARS_IN_DISPLAY_HREF);
    }

    public static Defect<StringDefectParams> restrictedCharsInDisplayHref(String notAllowedChars) {
        return new Defect<>(BannerDefectIds.String.RESTRICTED_CHARS_IN_DISPLAY_HREF,
                new StringDefectParams().withInvalidSubstrings(singletonList(notAllowedChars)));
    }

    public static Defect<Void> invalidTemplateQuery() {
        return new Defect<>(BannerDefectIds.Gen.INVALID_TEMPLATE_QUERY);
    }

    public static Defect<Void> cannotHaveTemplate() {
        return new Defect<>(BannerDefectIds.Gen.CANNOT_HAVE_TEMPLATE);
    }

    public static Defect<Void> invalidSitelinkSetIdUsage() {
        return new Defect<>(BannerDefectIds.Gen.INVALID_SITELINK_SET_USAGE);
    }

    public static Defect<Void> sitelinkDomainIsNotFitToBanner() {
        return new Defect<>(BannerDefectIds.Gen.SITELINK_DOMAIN_IS_NOT_FIT_TO_BANNER);
    }

    public static Defect<Void> invalidDisplayHrefUsage() {
        return new Defect<>(BannerDefectIds.Gen.INVALID_DISPLAY_HREF_USAGE);
    }

    public static Defect<Void> invalidIdInArrayElement() {
        return new Defect<>(BannerDefectIds.Gen.ARRAY_ELEMENT_INVALID_ID);
    }

    public static Defect<Void> emptyHref() {
        return new Defect<>(BannerDefectIds.Gen.EMPTY_HREF);
    }

    public static Defect<Void> emptyDisplayHref() {
        return new Defect<>(BannerDefectIds.Gen.EMPTY_DISPLAY_HREF);
    }

    public static Defect<StringDefectParams> stringShouldNotBeBlank() {
        return new Defect<>(BannerDefectIds.String.SHOULD_NOT_BE_BLANK);
    }

    public static Defect<Void> requiredButEmptyHrefOrTurboOrVcardIdOrPermalink() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_HREF_OR_VCARD_ID);
    }

    public static Defect<Void> requiredButEmptyHrefOrTurbolandingId() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_HREF_OR_TURBOLANDING_ID);
    }

    public static Defect<Void> requiredButEmptyImageHashOrCreativeId() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_IMAGE_HASH_OR_CREATIVE_ID);
    }

    public static Defect<Void> requiredOnlyImageOrCreativeId() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_ONLY_IMAGE_OR_CREATIVE_ID);
    }

    public static Defect<Void> cannotChangeImageToCreativeId() {
        return new Defect<>(BannerDefectIds.Gen.CANNOT_CHANGE_IMAGE_TO_CREATIVE_ID);
    }

    public static Defect<Void> cannotChangeCreativeToImageId() {
        return new Defect<>(BannerDefectIds.Gen.CANNOT_CHANGE_CREATIVE_ID_TO_IMAGE);
    }

    public static Defect<Void> bannerHrefIsIncompatibleWithPayForConversionStrategy() {
        return new Defect<>(BannerDefectIds.Gen.BANNER_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY);
    }

    public static Defect<Void> bannerSitelinksHrefIsIncompatibleWithPayForConversionStrategy() {
        return new Defect<>(BannerDefectIds.Gen.BANNER_SITELINKS_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY);
    }

    public static Defect<Void> inconsistentStateBannerTypeAndAdgroupType() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_ADGROUP_TYPE);
    }

    public static Defect<Void> inconsistentStateBannerTypeAndImageType() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_IMAGE_TYPE);
    }

    public static Defect<Void> inconsistentStateBannerTypeAndTurbolandingType() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_TURBOLANDING_TYPE);
    }

    public static Defect<Void> imageNotFound() {
        return new Defect<>(BannerDefectIds.Gen.IMAGE_NOT_FOUND);
    }

    public static Defect<Void> sitelinksSetNotFound() {
        return new Defect<>(BannerDefectIds.Gen.SITELINKS_SET_NOT_FOUND);
    }

    public static Defect<Void> turboPageNotFound() {
        return new Defect<>(BannerDefectIds.Gen.TURBO_PAGE_NOT_FOUND);
    }

    public static Defect<Void> vcardNotFound() {
        return new Defect<>(BannerDefectIds.Gen.VCARD_NOT_FOUND);
    }

    public static Defect<Void> creativeNotFound() {
        return new Defect<>(BannerDefectIds.Gen.CREATIVE_NOT_FOUND);
    }

    public static Defect<Void> videoExtensionNotFound() {
        return new Defect<>(BannerDefectIds.Gen.VIDEO_EXTENSION_NOT_FOUND);
    }

    public static Defect<Void> cpcVideoNotFound() {
        return new Defect<>(BannerDefectIds.Gen.CPC_VIDEO_NOT_FOUND);
    }

    public static Defect<Void> adNotFound() {
        return new Defect<>(BannerDefectIds.Gen.AD_NOT_FOUND);
    }

    public static Defect<Void> adGroupNotFound() {
        return new Defect<>(BannerDefectIds.Gen.AD_GROUP_NOT_FOUND);
    }

    public static Defect<Void> adGroupNotSupported() {
        return new Defect<>(BannerDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED);
    }

    public static Defect<ModelIdDefectParams> adExtensionNotFound(long adExtensionId) {
        return new Defect<>(BannerDefectIds.Id.AD_EXTENSION_NOT_FOUND,
                new ModelIdDefectParams().withId(adExtensionId));
    }

    public static Defect<Void> bannerModerateWithEmptyGroup() {
        return new Defect<>(BannerDefectIds.Gen.BANNER_MODERATE_WITH_EMPTY_GROUP);
    }

    public static Defect<Void> inconsistentStateBannerTypeAndIsMobile() {
        return new Defect<>(BannerDefectIds.Gen.FORBIDDEN_MOBILE_BANNER);
    }

    public static Defect<Void> actionInArchivedCampaign() {
        return new Defect<>(BannerDefectIds.Gen.ACTION_IN_ARCHIVED_CAMPAIGN);
    }

    public static Defect<Void> cannotUpdateArchivedAd() {
        return new Defect<>(BannerDefectIds.Gen.CANNOT_UPDATE_ARCHIVED_AD);
    }

    public static Defect<Void> addToArchivedCampaignNotAllowed() {
        return new Defect<>(BannerDefectIds.Gen.ADD_TO_ARCHIVED_CAMPAIGN_NOT_ALLOWED);
    }

    public static Defect<Void> clientHasntCreatives() {
        return new Defect<>(BannerDefectIds.Gen.CLIENT_HAS_NOT_CREATIVES);
    }

    public static Defect<Void> unsupportedBannerType() {
        return new Defect<>(BannerDefectIds.Gen.UNSUPPORTED_BANNER_TYPE);
    }

    public static Defect<Void> unsupportedButtonAction() {
        return new Defect<>(BannerDefectIds.Gen.UNSUPPORTED_BUTTON_ACTION);
    }

    public static Defect<Void> inconsistentBannerType() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_BANNER_TYPE);
    }

    public static Defect<Void> bannerTypeModification() {
        return new Defect<>(BannerDefectIds.Gen.BANNER_TYPE_MODIFICATION);
    }

    public static Defect<Void> imageSizeModification() {
        return new Defect<>(BannerDefectIds.Gen.IMAGE_SIZE_MODIFICATION);
    }

    public static Defect<Void> imageSizeNotFound() {
        return new Defect<>(BannerDefectIds.Gen.IMAGE_SIZE_NOT_FOUND);
    }

    public static Defect<Void> imageSizeInvalid() {
        return new Defect<>(BannerDefectIds.Gen.IMAGE_SIZE_INVALID);
    }

    public static Defect<Void> archivedBannerModification() {
        return new Defect<>(BannerDefectIds.Gen.ARCHIVED_BANNER_MODIFICATION);
    }

    public static Defect<Void> requiredCreativesWithVideoAdditionTypeOnly() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_VIDEO_ADDITION_TYPE_ONLY);
    }

    public static Defect<Void> requiredCreativesWithCpmVideoTypeOnly() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_CPM_VIDEO_TYPE_ONLY);
    }

    public static Defect<Void> inconsistentCreativeAndCpmVideoAdGroupSkippability() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_AND_CPM_VIDEO_AD_GROUP_SKIPPABILITY);
    }

    public static Defect<Void> requiredCreativesWithCpmAudioTypeOnly() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_CPM_AUDIO_TYPE_ONLY);
    }

    public static Defect<Void> requiredCreativesWithHtml5TypeOnly() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_HTML5_TYPE_ONLY);
    }

    public static Defect<Void> requiredCreativesWithCanvasOrHtml5Types() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_CANVAS_OR_HTML5_TYPES);
    }

    public static Defect<Void> requiredCreativesWithCanvasTypeOnly() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_CANVAS_TYPE_ONLY);
    }

    public static Defect<Void> inconsistentBannerCidAndCampaignId() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_BANNER_CID_AND_CAMPAIGN_ID);
    }

    public static Defect<Void> adMoreThanOnceInRequest() {
        return new Defect<>(BannerDefectIds.Gen.AD_MORE_THAN_ONCE_IN_REQUEST);
    }

    public static Defect<ModelIdDefectParams> duplicatedAdExtensionId(long id) {
        return new Defect<>(BannerDefectIds.Id.DUPLICATED_AD_EXTENSION_ID,
                new ModelIdDefectParams().withId(id));
    }

    /**
     * Превышение размера массива {@link OldBannerWithCallouts#CALLOUT_IDS}
     * при создании баннеров.
     */
    public static Defect<CollectionSizeDefectParams> maxAdExtensionsExceeded(int maxAdExtensions) {
        return new Defect<>(BannerDefectIds.Size.MAX_CALLOUTS_ON_BANNER_ADD,
                new CollectionSizeDefectParams().withMaxSize(maxAdExtensions));
    }

    /**
     * Превышение лимита уточнений на баннере при попытке обновления.
     */
    public static Defect<CollectionSizeDefectParams> maxAdExtensionsPerBannerExceeded(int maxAdExtensions) {
        return new Defect<>(BannerDefectIds.Size.MAX_CALLOUTS_PER_BANNER,
                new CollectionSizeDefectParams().withMaxSize(maxAdExtensions));
    }

    public static Defect<NumberDefectParams> maxBannersInAdGroup(int maxBanners) {
        return new Defect<>(BannerDefectIds.Num.MAX_BANNERS_IN_ADGROUP,
                new NumberDefectParams().withMax(maxBanners));
    }

    public static Defect<NumberDefectParams> maxBannersInInternalCampaign(int maxBanners) {
        return new Defect<>(BannerDefectIds.Num.MAX_BANNERS_IN_INTERNAL_CAMPAIGN,
                new NumberDefectParams().withMax(maxBanners));
    }

    public static Defect<NumberDefectParams> maxBannersInUniversalAppCampaign(int maxBanners) {
        return new Defect<>(BannerDefectIds.Num.MAX_BANNERS_IN_UNIVERSAL_APP_CAMPAIGN,
                new NumberDefectParams().withMax(maxBanners));
    }

    public static Defect<StringDefectParams> maxLengthDisplayHref(int maxLength) {
        return new Defect<>(BannerDefectIds.String.DISPLAY_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect<StringDefectParams> maxTextLengthWithoutTemplateMarker(int maxStringLength) {
        return new Defect<>(BannerDefectIds.String.TEXT_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxStringLength));
    }

    public static Defect<StringDefectParams> maxHrefLengthWithoutTemplateMarker(int maxHrefLength) {
        return new Defect<>(BannerDefectIds.String.HREF_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxHrefLength));
    }

    public static Defect<StringDefectParams> maxLengthWordTemplateMarker(int maxLength) {
        return new Defect<>(
                BannerDefectIds.String.LENGTH_WORD_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect<Language> inconsistentLanguageWithGeo(Language language) {
        return new Defect<>(BannerDefectIds.LanguageDefect.INCONSISTENT_LANGUAGE_WITH_GEO, language);
    }

    public static Defect<StringDefectParams> maxNumberOfNarrowCharacters(int maxLength) {
        return new Defect<>(
                BannerDefectIds.String.MAX_NUMBER_OF_NARROW_CHARACTERS_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxLength));
    }

    public static Defect<Void> insufficientRights() {
        return new Defect<>(BannerDefectIds.Gen.INSUFFICIENT_RIGHTS);
    }

    public static Defect<Void> trackingSystemDomainNotSupported() {
        return new Defect<>(BannerDefectIds.Gen.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED);
    }

    public static Defect<Void> trackingSystemDomainSupportsHttpsOnly() {
        return new Defect<>(BannerDefectIds.Gen.THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS);
    }

    public static Defect<Void> trackingUrlDoesntContainMacros() {
        return new Defect<>(BannerDefectIds.Gen.TRACKING_URL_DOESNT_CONTAIN_MACROS);
    }

    public static Defect<Void> vcardOfAnotherCampaign() {
        return new Defect<>(BannerDefectIds.Gen.VCARD_OF_ANOTHER_CAMPAIGN);
    }

    public static Defect<Void> restrictedCharsInField() {
        return new Defect<>(BannerDefectIds.Gen.RESTRICTED_CHARS_IN_FIELD);
    }

    public static Defect<Void> absentValueInField() {
        return new Defect<>(BannerDefectIds.Gen.EMPTY_VALUE);
    }

    public static Defect<ModelIdDefectParams> suspendInArchivedCampaign(long campaignId) {
        return new Defect<>(BannerDefectIds.Id.SUSPEND_IN_ARCHIVED_CAMPAIGN,
                new ModelIdDefectParams().withId(campaignId));
    }

    public static Defect<ModelIdDefectParams> resumeInArchivedCampaign(long campaignId) {
        return new Defect<>(BannerDefectIds.Id.RESUME_IN_ARCHIVED_CAMPAIGN,
                new ModelIdDefectParams().withId(campaignId));
    }

    public static Defect<Void> suspendArchivedBanner() {
        return new Defect<>(BannerDefectIds.Gen.SUSPEND_ARCHIVED_BANNER);
    }

    public static Defect<Void> resumeArchivedBanner() {
        return new Defect<>(BannerDefectIds.Gen.RESUME_ARCHIVED_BANNER);
    }

    public static Defect<Void> suspendDraftBanner() {
        return new Defect<>(BannerDefectIds.Gen.SUSPEND_DRAFT_BANNER);
    }

    public static Defect<Void> resumeDraftBanner() {
        return new Defect<>(BannerDefectIds.Gen.RESUME_DRAFT_BANNER);
    }

    public static Defect<Void> alreadySuspended() {
        return new Defect<>(BannerDefectIds.Gen.ALREADY_SUSPENDED);
    }

    public static Defect<Void> isNotSuspended() {
        return new Defect<>(BannerDefectIds.Gen.IS_NOT_SUSPENDED);
    }

    public static Defect<Void> cannotChangeBannerFlagsFromBabyFoodToOtherTypes() {
        return new Defect<>(BannerDefectIds.Gen.CANNOT_CHANGE_BANNER_FLAGS_FROM_BABY_FOOD_TO_OTHER_TYPES);
    }

    public static Defect<Void> cannotChangeBannerFlagsFromAgeToOtherTypes() {
        return new Defect<>(BannerDefectIds.Gen.CANNOT_CHANGE_BANNER_FLAGS_FROM_AGE_TO_OTHER_TYPES);
    }

    public static Defect<Void> clientCannotSetBannerFlags() {
        return new Defect<>(BannerDefectIds.Gen.CLIENT_CANNOT_SET_BANNER_FLAGS);
    }

    public static Defect<ModelIdDefectParams> archiveInArchivedCampaign(long id) {
        return new Defect<>(BannerDefectIds.Id.ARCHIVE_IN_ARCHIVED_CAMPAIGN,
                new ModelIdDefectParams().withId(id));
    }

    public static Defect<ModelIdDefectParams> unarchiveInArchivedCampaign(long id) {
        return new Defect<>(BannerDefectIds.Id.UNARCHIVE_IN_ARCHIVED_CAMPAIGN,
                new ModelIdDefectParams().withId(id));
    }

    public static Defect<Void> alreadyArchived() {
        return new Defect<>(BannerDefectIds.Gen.ALREADY_ARCHIVED);
    }

    public static Defect<Void> isNotArchived() {
        return new Defect<>(BannerDefectIds.Gen.IS_NOT_ARCHIVED);
    }

    public static Defect<Void> archiveDraftBanner() {
        return new Defect<>(BannerDefectIds.Gen.ARCHIVE_DRAFT_BANNER);
    }

    public static Defect<Void> archiveBannerShownInBs() {
        return new Defect<>(BannerDefectIds.Gen.ARCHIVE_BANNER_SHOWN_IN_BS);
    }

    public static Defect<Void> inconsistentCreativeTypeToBannerType() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_TYPE_TO_BANNER_TYPE);
    }

    public static Defect<Void> inconsistentCreativeBusinessTypeToFeedBusinessType() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_BUSINESS_TYPE_TO_FEED_BUSINESS_TYPE);
    }

    public static Defect<Void> inconsistentCreativeGeoToAdGroupGeo() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_GEO_TO_ADGROUP_GEO);
    }

    public static Defect<Void> inconsistentCreativeFormat() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_FORMAT);
    }

    public static Defect<Void> unableToDelete() {
        return new Defect<>(BannerDefectIds.Gen.UNABLE_TO_DELETE);
    }

    public static Defect<Void> invalidPixelFormat() {
        return new Defect<>(BannerDefectIds.Gen.INVALID_PIXEL_FORMAT);
    }

    public static Defect<PixelPermissionsDefectParams> noRightsToPixel(String pixelUrl,
                                                                       List<PixelPermissionInfo> clientPermissions,
                                                                       CampaignType campaignType,
                                                                       InventoryType bannerInventoryType) {
        return noRightsToPixel(pixelUrl, PixelUtils.getAccessibleClientProviders(clientPermissions,
                campaignType, bannerInventoryType)
                .stream()
                .collect(Collectors.toSet()));
    }

    public static Defect<PixelPermissionsDefectParams> noRightsToPixel(String pixelUrl,
                                                                       Set<PixelProvider> accessibleProviders) {
        List<String> accessibleProviderNames = accessibleProviders.stream()
                .map(PixelProvider::getProviderName)
                .filter(s -> !s.equals(PixelProvider.YANDEXAUDIENCE.getProviderName()))
                .collect(Collectors.toList());
        Collections.sort(accessibleProviderNames);
        return new Defect<>(BannerDefectIds.PixelPermissions.NO_RIGHTS_TO_PIXEL,
                new PixelPermissionsDefectParams()
                        .withPixelUrl(pixelUrl)
                        .withAccessibleClientProviderNames(accessibleProviderNames));
    }

    public static Defect<StringDefectParams> noRightsToAudiencePixel(String pixelUrl) {
        return new Defect<>(BannerDefectIds.String.NO_RIGHTS_TO_AUDIENCE_PIXEL,
                new StringDefectParams().withInvalidSubstrings(singletonList(pixelUrl)));
    }

    public static Defect<PixelWithMeasurerDefectParams> invalidPixelWithMeasurer(
            String pixelUrl,
            String measurerSystemName
    ) {
        return new Defect<>(BannerDefectIds.PixelWithMeasurer.INVALID_PIXEL_WITH_MEASURER,
                new PixelWithMeasurerDefectParams()
                        .withPixelUrl(pixelUrl)
                        .withMeasurerSystemName(measurerSystemName));
    }

    /**
     * Превышение лимита числа пикселей Я.Аудиторий на баннере
     */
    public static Defect<CollectionSizeDefectParams> pixelNumberYaAudienceLimitExceeded() {
        return new Defect<>(BannerDefectIds.Size.MAX_YA_AUD_PIXELS_ON_BANNER);
    }

    /**
     * Превышение лимита числа пикселей не Я.Аудиторий на баннере
     */
    public static Defect<CollectionSizeDefectParams> pixelNumberNonYaAudienceLimitExceeded() {
        return new Defect<>(BannerDefectIds.Size.MAX_FOREIGN_PIXELS_ON_BANNER);
    }

    /**
     * Превышение лимита числа пикселей одного провайдера на баннере
     *
     * @param exceededPixelProviderNames список имён провайдеров, у которых нарушено ограничение
     */
    public static Defect<PixelProvidersLimitsDefectParams> equalPixelProvidersLimitExceeded(
            List<String> exceededPixelProviderNames) {
        return new Defect<>(BannerDefectIds.PixelProviderLimits.EQUAL_PIXEL_PROVIDERS,
                new PixelProvidersLimitsDefectParams()
                        .withExceededClientPixelProviderNames(exceededPixelProviderNames));
    }

    public static Defect<Void> moderateArchivedBanner() {
        return new Defect<>(BannerDefectIds.Gen.MODERATE_ARCHIVED_BANNER);
    }

    public static Defect<Void> moderateNonDraftBanner() {
        return new Defect<>(BannerDefectIds.Gen.MODERATE_NON_DRAFT_BANNER);
    }

    public static Defect<Void> remoderateDraftBanner() {
        return new Defect<>(BannerDefectIds.Gen.REMODERATE_DRAFT_BANNER);
    }

    public static Defect<Void> moderateBannerInAdGroupWithoutShowConditions() {
        return new Defect<>(BannerDefectIds.Gen.MODERATE_BANNER_IN_GROUP_WITHOUT_SHOW_CONDITIONS);
    }

    public static Defect<ModelIdDefectParams> moderateBannerInArchivedCampaign(long id) {
        return new Defect<>(BannerDefectIds.Id.MODERATE_BANNER_IN_ARCHIVED_CAMPAIGN,
                new ModelIdDefectParams().withId(id));
    }

    public static Defect<ModelIdDefectParams> remoderateBannerInDraftCampaign(long id) {
        return new Defect<>(BannerDefectIds.Id.REMODERATE_BANNER_IN_DRAFT_CAMPAIGN,
                new ModelIdDefectParams().withId(id));
    }

    public static Defect<Void> remoderateBannerIsNotAllowed() {
        return new Defect<>(BannerDefectIds.Gen.REMODERATE_BANNER_IS_NOT_ALLOWED);
    }

    public static Defect<CollectionValuesDefectParams<Long>> remoderateBannerWithNotAllowedModReasons(
            Set<Long> notAllowedModReasons) {
        return new Defect<>(BannerDefectIds.ModReasons.REMODERATE_BANNER_WITH_NOT_ALLOWED_MOD_REASONS,
                CollectionValuesDefectParams.of(notAllowedModReasons));
    }

    public static Defect<Void> remoderateBannerWithNoModReasons() {
        return new Defect<>(BannerDefectIds.Gen.REMODERATE_BANNER_WITH_NO_MOD_REASONS);
    }

    public static Defect<Void> forbiddenToChange() {
        return new Defect<>(BannerDefectIds.Gen.FORBIDDEN_TO_CHANGE);
    }

    public static Defect<Void> cannotHaveTurbolandings() {
        return new Defect<>((BannerDefectIds.Gen.CANNOT_HAVE_TURBOLANDINGS));
    }

    public static Defect<Void> contentTypeNotMatchesAdGroupContentType() {
        return new Defect<>((BannerDefectIds.Gen.CONTENT_TYPE_NOT_MATCHES_ADGROUP_CONTENT_TYPE));
    }

    public static Defect<Void> contentPromotionVideoIsInaccessible() {
        return new Defect<>(BannerDefectIds.Gen.CONTENT_PROMOTION_VIDEO_IS_INACCESSIBLE);
    }

    public static Defect<Void> contentPromotionCollectionIsInaccessible() {
        return new Defect<>(BannerDefectIds.Gen.CONTENT_PROMOTION_COLLECTION_IS_INACCESSIBLE);
    }

    public static Defect<Void> priceMissing() {
        return new Defect<>(BannerDefectIds.Gen.BANNER_PRICE_MISSING);
    }

    public static Defect<Void> currencyMissing() {
        return new Defect<>(BannerDefectIds.Gen.BANNER_PRICE_CURRENCY_MISSING);
    }

    public static Defect<Void> priceGreaterThanOld() {
        return new Defect<>(BannerDefectIds.Gen.BANNER_PRICE_GREATER_THAN_OLD);
    }

    public static Defect<Void> bannerCannotHaveTurboGalleryHref() {
        return new Defect<>(BannerDefectIds.Gen.BANNER_CANNOT_HAVE_TURBO_GALLERY_HREF);
    }

    public static Defect<Void> internalTemplateNotAllowed() {
        return new Defect<>(BannerDefectIds.Gen.INTERNAL_TEMPLATE_NOT_ALLOWED);
    }

    public static Defect<Void> templateVariablesMismatch() {
        return new Defect<>(BannerDefectIds.Gen.INTERNAL_TEMPLATE_VARIABLES_MISMATCH);
    }

    public static Defect<Void> requiredCampaignsImpressionRateButEmpty() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_CAMPAIGNS_IMPRESSION_RATE_BUT_EMPTY);
    }

    public static Defect<Void> requiredAdGroupsImpressionRateButEmpty() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_AD_GROUPS_IMPRESSION_RATE_BUT_EMPTY);
    }

    public static Defect<Void> requiredCampaignOrAdGroupMaxStopsCountButEmpty() {
        return new Defect<>(BannerDefectIds.Gen.REQUIRED_CAMPAIGN_OR_AD_GROUP_MAX_STOPS_COUNT_BUT_EMPTY);
    }

    public static Defect<NumberDefectParams> priceLessThanMin(BigDecimal min) {
        return new Defect<>(BannerDefectIds.Price.MUST_BE_GREATER_THAN_MIN,
                new NumberDefectParams().withMin(min));
    }

    public static Defect<NumberDefectParams> priceGreaterThanMax(BigDecimal max) {
        return new Defect<>(BannerDefectIds.Price.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
                new NumberDefectParams().withMax(max));
    }

    public static Defect<Void> priceSalesFullnessViolated() {
        return new Defect<>(BannerDefectIds.Gen.PRICE_SALES_FULLNESS_VIOLATED);
    }

    public static Defect<Void> priceSalesCampaignGeoOverlapsBannerMinusGeo() {
        return new Defect<>(BannerDefectIds.Gen.PRICE_SALES_CAMPAIGN_GEO_OVERLAPS_BANNER_MINUS_GEO);
    }

    public static Defect<Void> priceSalesDisallowedCreativeTemplate() {
        return new Defect<>(BannerDefectIds.Gen.PRICE_SALES_DISALLOWED_CREATIVE_TEMPLATE);
    }

    public static Defect<StringDefectParams> invalidSpecSymbols(String specSymbol) {
        return new Defect<>(BannerDefectIds.String.INVALID_SPEC_SYMBOL,
                new StringDefectParams().withInvalidSubstrings(singletonList(specSymbol)));
    }

    public static Defect<Void> errorsWhileCopyingBanners() {
        return new Defect<>(BannerDefectIds.Gen.ERRORS_WHILE_COPYING_BANNERS);
    }

    public static Defect<Void> inconsistentLeadformHrefAndButtonText() {
        return new Defect<>(BannerDefectIds.Gen.INCONSISTENT_LEADFORM_HREF_AND_BUTTON_TEXT);
    }

    public static Defect<Void> differentTemplateIdsNotAllowed() {
        return new Defect<>(BannerDefectIds.Gen.DIFFERENT_TEMPLATES_NOT_ALLOWED);
    }

    public static Defect<Void> templateResourceIdNotFound() {
        return new Defect<>(BannerDefectIds.Gen.TEMPLATE_RESOURCE_ID_NOT_FOUND);
    }

    public static Defect<Void> templateMustBeModerated() {
        return new Defect<>(BannerDefectIds.Gen.TEMPLATE_MUST_BE_MODERATED);
    }

    public static Defect<Void> incorrectImpressionUrlTrackingSystem() {
        return new Defect<>(BannerDefectIds.Gen.INCORRECT_IMPRESSION_URL_TRACKING_SYSTEM);
    }

    public static Defect<Void> incorrectImpressionUrlTrackerId() {
        return new Defect<>(BannerDefectIds.Gen.INCORRECT_IMPRESSION_URL_TRACKER_ID);
    }
}
