package ru.yandex.direct.core.entity.banner.service.validation.defects;

import java.util.List;
import java.util.Objects;

public class PixelPermissionsDefectParams {
    private String pixelUrl;
    private List<String> accessibleClientProviderNames;

    public String getPixelUrl() {
        return pixelUrl;
    }

    public PixelPermissionsDefectParams withPixelUrl(String pixelUrl) {
        this.pixelUrl = pixelUrl;
        return this;
    }

    public List<String> getAccessibleClientProviderNames() {
        return accessibleClientProviderNames;
    }

    public PixelPermissionsDefectParams withAccessibleClientProviderNames(List<String> accessibleClientProviderNames) {
        this.accessibleClientProviderNames = accessibleClientProviderNames;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PixelPermissionsDefectParams that = (PixelPermissionsDefectParams) o;
        return Objects.equals(pixelUrl, that.pixelUrl) &&
                Objects.equals(accessibleClientProviderNames, that.accessibleClientProviderNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pixelUrl, accessibleClientProviderNames);
    }

    @Override
    public String toString() {
        return "PixelPermissionsDefectParams{" +
                "pixelUrl='" + pixelUrl + '\'' +
                ", accessibleClientProviderNames=" + accessibleClientProviderNames +
                '}';
    }
}
