package ru.yandex.direct.core.entity.banner.service.validation.defects;

import java.util.List;
import java.util.Objects;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.utils.CommonUtils.nvl;

/**
 * Параметры ошибки, когда превышено допустимое число пикселей одного провайдера на баннере
 */
public class PixelProvidersLimitsDefectParams {

    /**
     * Вернуть список имён провайдеров, для которых превышено допустимое число пикселей одного провайдера
     */
    private List<String> exceededClientPixelProviderNames;

    public List<String> getExceededClientPixelProviderNames() {
        return exceededClientPixelProviderNames;
    }

    /**
     * Вернуть список провайдеров, для которых превышено допустимое число пикселей одного провайдера,
     * одной строкой через запятую
     */
    public String getExceededClientPixelProviderNamesJoined() {
        return String.join(", ", nvl(exceededClientPixelProviderNames, emptyList()));
    }

    public PixelProvidersLimitsDefectParams withExceededClientPixelProviderNames(
            List<String> exceededClientPixelProviderNames)
    {
        this.exceededClientPixelProviderNames = exceededClientPixelProviderNames;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PixelProvidersLimitsDefectParams that = (PixelProvidersLimitsDefectParams) o;
        return Objects.equals(exceededClientPixelProviderNames, that.exceededClientPixelProviderNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(exceededClientPixelProviderNames);
    }

    @Override
    public String toString() {
        return "PixelPermissionsDefectParams{" +
                ", accessibleClientProviderNames=" + exceededClientPixelProviderNames +
                '}';
    }
}
