package ru.yandex.direct.core.entity.banner.service.validation.defects;

import java.util.Objects;

public class PixelWithMeasurerDefectParams {
    private String pixelUrl;
    private String measurerSystemName;

    public String getPixelUrl() {
        return pixelUrl;
    }

    public PixelWithMeasurerDefectParams withPixelUrl(String pixelUrl) {
        this.pixelUrl = pixelUrl;
        return this;
    }

    public String getMeasurerSystemName() {
        return measurerSystemName;
    }

    public PixelWithMeasurerDefectParams withMeasurerSystemName(String measurerSystemName) {
        this.measurerSystemName = measurerSystemName;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PixelWithMeasurerDefectParams that = (PixelWithMeasurerDefectParams) o;
        return Objects.equals(pixelUrl, that.pixelUrl) &&
                Objects.equals(measurerSystemName, that.measurerSystemName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pixelUrl, measurerSystemName);
    }

    @Override
    public String toString() {
        return "PixelWithMeasurerDefectParams{" +
                "pixelUrl='" + pixelUrl + '\'' +
                ", measurerSystemName=" + measurerSystemName +
                '}';
    }
}
