package ru.yandex.direct.core.entity.banner.service.validation.pricesales;

import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.repository.BannerModerationRepository;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.core.entity.pricepackage.service.PricePackageService;

@Component
public class BannerPriceSalesMinusGeoValidatorFactory {

    private final CampaignTypedRepository campaignTypedRepository;
    private final AdGroupRepository adGroupRepository;
    private final BannerModerationRepository bannerModerationRepository;
    private final PricePackageService pricePackageService;

    public BannerPriceSalesMinusGeoValidatorFactory(
            CampaignTypedRepository campaignTypedRepository,
            AdGroupRepository adGroupRepository,
            BannerModerationRepository bannerModerationRepository,
            PricePackageService pricePackageService) {
        this.campaignTypedRepository = campaignTypedRepository;
        this.adGroupRepository = adGroupRepository;
        this.bannerModerationRepository = bannerModerationRepository;
        this.pricePackageService = pricePackageService;
    }

    public BannerPriceSalesMinusGeoValidator create(
            int shard,
            Map<Long, BannerWithSystemFields> banners,
            Map<Long, Campaign> campaigns) {
        return new BannerPriceSalesMinusGeoValidator(
                shard,
                banners,
                campaigns,
                campaignTypedRepository,
                bannerModerationRepository,
                adGroupRepository,
                pricePackageService
        );
    }
}
