package ru.yandex.direct.core.entity.banner.service.validation.type;

import java.util.function.Predicate;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.model.TextBanner;

public class BannerTypeValidationPredicates {

    private BannerTypeValidationPredicates() {
    }

    public static boolean isTextBanner(Banner banner) {
        return banner instanceof TextBanner;
    }

    public static boolean isImageBanner(Banner banner) {
        return banner instanceof ImageBanner;
    }

    public static boolean isImageHashBanner(Banner banner) {
        return banner instanceof ImageBanner && ((ImageBanner) banner).getImageHash() != null;
    }

    public static boolean isImageCreativeBanner(Banner banner) {
        return banner instanceof ImageBanner && ((ImageBanner) banner).getCreativeId() != null;
    }

    public static boolean isCpcVideoBanner(Banner banner) {
        return banner instanceof CpcVideoBanner;
    }

    public static boolean isCpmBanner(Banner banner) {
        return banner instanceof CpmBanner;
    }

    public static boolean isCpmAudioBanner(Banner banner) {
        return banner instanceof CpmAudioBanner;
    }

    public static boolean isCpmOutdoorBanner(Banner banner) {
        return banner instanceof CpmOutdoorBanner;
    }

    public static boolean isCpmIndoorBanner(Banner banner) {
        return banner instanceof CpmIndoorBanner;
    }

    public static boolean isCpmGeoPinBanner(Banner banner) {
        return banner instanceof CpmGeoPinBanner;
    }

    public static boolean isContentPromotionBanner(Banner banner) {
        return banner instanceof ContentPromotionBanner;
    }

    public static boolean isDynamicBanner(Banner banner) {
        return banner instanceof DynamicBanner;
    }

    public static boolean isMcBannerBanner(Banner banner) {
        return banner instanceof McBanner;
    }

    public static boolean isMobileAppBanner(Banner banner) {
        return banner instanceof MobileAppBanner;
    }

    public static boolean isInternalBanner(Banner banner) {
        return banner instanceof InternalBanner;
    }

    public static boolean isPerformanceBanner(Banner banner) {
        return banner instanceof PerformanceBanner;
    }

    public static boolean isPerformanceBannerMain(Banner banner) {
        return banner instanceof PerformanceBannerMain;
    }

    public static boolean isTextBanner(Class<? extends Banner> bannerClass) {
        return TextBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isImageBanner(Class<? extends Banner> bannerClass) {
        return ImageBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isCpcVideoBanner(Class<? extends Banner> bannerClass) {
        return CpcVideoBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isCpmBanner(Class<? extends Banner> bannerClass) {
        return CpmBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isCpmAudioBanner(Class<? extends Banner> bannerClass) {
        return CpmAudioBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isCpmOutdoorBanner(Class<? extends Banner> bannerClass) {
        return CpmOutdoorBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isCpmIndoorBanner(Class<? extends Banner> bannerClass) {
        return CpmIndoorBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isCpmGeoPinBanner(Class<? extends Banner> bannerClass) {
        return CpmGeoPinBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isContentPromotionBanner(Class<? extends Banner> bannerClass) {
        return ContentPromotionBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isMcBanner(Class<? extends Banner> bannerClass) {
        return McBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isMobileAppBanner(Class<? extends Banner> bannerClass) {
        return MobileAppBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isInternalBanner(Class<? extends Banner> bannerClass) {
        return InternalBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isPerformanceBanner(Class<? extends Banner> bannerClass) {
        return PerformanceBanner.class.isAssignableFrom(bannerClass);
    }

    public static boolean isDynamicBanner(Class<? extends Banner> bannerClass) {
        return DynamicBanner.class.isAssignableFrom(bannerClass);
    }

    public static <B extends Banner> Predicate<B> isTextBanner() {
        return BannerTypeValidationPredicates::isTextBanner;
    }

    public static <B extends Banner> Predicate<B> isCpmBanner() {
        return BannerTypeValidationPredicates::isCpmBanner;
    }

    public static <B extends Banner> Predicate<B> isPerformanceBanner() {
        return BannerTypeValidationPredicates::isPerformanceBanner;
    }
}
