package ru.yandex.direct.core.entity.banner.type.additionalhrefs;

import ru.yandex.direct.core.entity.banner.model.BannerAdditionalHref;
import ru.yandex.direct.core.entity.banner.type.href.BannerHrefValidator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class BannerAdditionalHrefValidator implements DefaultValidator<BannerAdditionalHref> {

    @Override
    public ValidationResult<BannerAdditionalHref, Defect> apply(BannerAdditionalHref additionalHref) {
        ModelItemValidationBuilder<BannerAdditionalHref> vb = ModelItemValidationBuilder.of(additionalHref);

        vb.item(BannerAdditionalHref.HREF)
                .check(notNull())
                .checkBy(new BannerHrefValidator(), When.isValid());

        return vb.getResult();
    }
}
