package ru.yandex.direct.core.entity.banner.type.additionalhrefs;

import java.util.List;

import ru.yandex.direct.core.entity.banner.model.BannerAdditionalHref;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static ru.yandex.direct.core.entity.banner.type.additionalhrefs.BannerWithAdditionalHrefsConstants.MAX_ADDITIONAL_HREFS_COUNT_ON_BANNER;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.isEmptyCollection;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class BannerAdditionalHrefsValidator implements DefaultValidator<List<BannerAdditionalHref>> {

    private final boolean additionalHrefsAllowed;

    public BannerAdditionalHrefsValidator(boolean additionalHrefsAllowed) {
        this.additionalHrefsAllowed = additionalHrefsAllowed;
    }

    @Override
    public ValidationResult<List<BannerAdditionalHref>, Defect> apply(List<BannerAdditionalHref> additionalHrefs) {
        ListValidationBuilder<BannerAdditionalHref, Defect> vb = ListValidationBuilder.of(additionalHrefs);

        if (!additionalHrefsAllowed) {
            vb.check(isEmptyCollection());
            return vb.getResult();
        }

        return vb
                .check(maxListSize(MAX_ADDITIONAL_HREFS_COUNT_ON_BANNER))
                .checkEach(notNull())
                .checkEachBy(new BannerAdditionalHrefValidator(), When.isValid())
                .getResult();
    }
}
