package ru.yandex.direct.core.entity.banner.type.additionalhrefs;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdditionalHrefs;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithAdditionalHrefsAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithAdditionalHrefs> {

    private final BannerWithAdditionalHrefsValidatorProvider validatorProvider;

    @Autowired
    public BannerWithAdditionalHrefsAddValidationTypeSupport(
            BannerWithAdditionalHrefsValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithAdditionalHrefs> getTypeClass() {
        return BannerWithAdditionalHrefs.class;
    }

    @Override
    public ValidationResult<List<BannerWithAdditionalHrefs>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithAdditionalHrefs>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithAdditionalHrefs(container))
                .getResult();
    }
}
