package ru.yandex.direct.core.entity.banner.type.additionalhrefs;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdditionalHrefs;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.additionalhrefs.BannerWithAdditionalHrefsUtils.isAdditionalHrefsChanged;

@Component
public class BannerWithAdditionalHrefsUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithAdditionalHrefs> {

    @Override
    public Class<BannerWithAdditionalHrefs> getTypeClass() {
        return BannerWithAdditionalHrefs.class;
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithAdditionalHrefs> appliedChanges) {
        return isAdditionalHrefsChanged(appliedChanges);
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithAdditionalHrefs> appliedChanges) {
        return isAdditionalHrefsChanged(appliedChanges);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithAdditionalHrefs> appliedChanges) {
        return isAdditionalHrefsChanged(appliedChanges);
    }
}
