package ru.yandex.direct.core.entity.banner.type.additionalhrefs;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdditionalHrefs;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithAdditionalHrefsUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithAdditionalHrefs> {

    private final BannerWithAdditionalHrefsValidatorProvider validatorProvider;

    @Autowired
    public BannerWithAdditionalHrefsUpdateValidationTypeSupport(
            BannerWithAdditionalHrefsValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithAdditionalHrefs> getTypeClass() {
        return BannerWithAdditionalHrefs.class;
    }

    @Override
    public ValidationResult<List<BannerWithAdditionalHrefs>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithAdditionalHrefs>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithAdditionalHrefs(container))
                .getResult();
    }
}
