package ru.yandex.direct.core.entity.banner.type.additionalhrefs;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerAdditionalHref;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdditionalHrefs;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@ParametersAreNonnullByDefault
public class BannerWithAdditionalHrefsUtils {
    private BannerWithAdditionalHrefsUtils() {
    }

    public static boolean isAdditionalHrefsChanged(@Nonnull AppliedChanges<? extends BannerWithAdditionalHrefs> ac) {
        List<BannerAdditionalHref> oldValue =
                normalizeAdditionalHrefs(ac.getOldValue(BannerWithAdditionalHrefs.ADDITIONAL_HREFS));
        List<BannerAdditionalHref> newValue =
                normalizeAdditionalHrefs(ac.getNewValue(BannerWithAdditionalHrefs.ADDITIONAL_HREFS));
        return !Objects.equals(oldValue, newValue);
    }

    private static List<BannerAdditionalHref> normalizeAdditionalHrefs(
            @Nullable List<BannerAdditionalHref> additionalHrefs) {
        return nvl(additionalHrefs, emptyList());
    }
}
