package ru.yandex.direct.core.entity.banner.type.additionalhrefs;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdditionalHrefs;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerWithAdditionalHrefs.ADDITIONAL_HREFS;
import static ru.yandex.direct.feature.FeatureName.CPM_PRICE_BANNER_ADDITIONAL_HREFS_ALLOWED;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@Component
public class BannerWithAdditionalHrefsValidatorProvider {

    public Validator<BannerWithAdditionalHrefs, Defect> bannerWithAdditionalHrefs(
            BannersOperationContainer container) {
        return banner -> {
            ModelItemValidationBuilder<BannerWithAdditionalHrefs> builder = ModelItemValidationBuilder.of(banner);

            builder.item(ADDITIONAL_HREFS)
                    .checkBy(new BannerAdditionalHrefsValidator(isAdditionalHrefsAllowed(container, banner)));

            return builder.getResult();
        };
    }

    private boolean isAdditionalHrefsAllowed(BannersOperationContainer container, BannerWithAdditionalHrefs banner) {
        CampaignType campaignType = ifNotNull(container.getCampaign(banner), CommonCampaign::getType);
        return container.isFeatureEnabledForClient(CPM_PRICE_BANNER_ADDITIONAL_HREFS_ALLOWED)
                && campaignType == CampaignType.CPM_PRICE;
    }
}
