package ru.yandex.direct.core.entity.banner.type.adgroupid;

import java.util.Map;
import java.util.function.Predicate;

import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignSubObjectAccessConstraint;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints.limitBannersInGroup;
import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints.limitBannersInInternalCampaign;
import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints.limitBannersInUniversalAppCampaign;


public class BannerToAdGroupConnectionValidator<B extends ModelWithId> implements Validator<B, Defect> {

    private final ModelProperty<? super B, Long> adGroupIdProperty;
    private final Predicate<B> isInternalBanner;
    // баннер performance_main можно добавить в группу, даже если группа уже полностью заполнена
    private final Predicate<B> isPerformanceBannerMain;
    private final BannerWithAdGroupIdValidationContainer container;
    private final CampaignSubObjectAccessConstraint campaignLevelAccessConstraint;
    private final boolean isAddOperation;

    public BannerToAdGroupConnectionValidator(
            ModelProperty<? super B, Long> adGroupIdProperty,
            Predicate<B> isInternalBanner,
            Predicate<B> isPerformanceBannerMain,
            BannerWithAdGroupIdValidationContainer container,
            CampaignSubObjectAccessConstraint campaignLevelAccessConstraint,
            boolean isAddOperation) {
        this.adGroupIdProperty = adGroupIdProperty;
        this.isInternalBanner = isInternalBanner;
        this.isPerformanceBannerMain = isPerformanceBannerMain;
        this.container = container;
        this.campaignLevelAccessConstraint = campaignLevelAccessConstraint;
        this.isAddOperation = isAddOperation;
    }

    @Override
    public ValidationResult<B, Defect> apply(B banner) {
        ModelItemValidationBuilder<B> vb = ModelItemValidationBuilder.of(banner);

        Long adGroupId = adGroupIdProperty.get(banner);
        var adGroup = container.getAdGroup(adGroupId);

        if (adGroupId != null) {

            boolean isUAC = adGroup != null && container.isUniversalCampaign(adGroup.getCampaignId());
            boolean isUacTextCampaign =
                    adGroup != null && container.isUniversalTextCampaign(adGroup.getCampaignId());

            Map<Long, Long> bannersCounter = isUAC
                    ? container.getGroupNotArchivedBannersCounter()
                    : container.getGroupBannersCounter();

            vb.check(limitBannersInGroup(
                    adGroupIdProperty,
                    bannersCounter,
                    adGroup,
                    isUAC,
                    isUacTextCampaign
            ), When.isTrue(isAddOperation && !isPerformanceBannerMain.test(banner)));

            if (adGroup != null) {
                vb.check(limitBannersInInternalCampaign(container.getCampaignBannersCounter().get(adGroup.getCampaignId())),
                        When.isTrue(isAddOperation && isInternalBanner.test(banner)));
                vb.check(limitBannersInUniversalAppCampaign(container.getCampaignBannersCounter().get(adGroup.getCampaignId())),
                        When.isTrue(isAddOperation && isUAC));
            }
        }

        vb.item(adGroupIdProperty)
                .check(campaignLevelAccessConstraint);

        return vb.getResult();
    }
}
