package ru.yandex.direct.core.entity.banner.type.adgroupid;

import java.util.List;
import java.util.function.Function;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints;
import ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignSubObjectAccessCheckerFactory;
import ru.yandex.direct.core.entity.campaign.service.accesschecker.CampaignSubObjectAccessConstraint;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignAccessType;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.addToArchivedCampaignNotAllowed;
import static ru.yandex.direct.core.entity.campaign.service.accesschecker.AccessDefectPresets.AD_GROUP_ACCESS_DEFECTS_FOR_BANNER;

@Component
public class BannerWithAdGroupIdAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithAdGroupId> {

    private final BannerWithAdGroupIdValidationContainerFiller containerFiller;
    private final CampaignSubObjectAccessCheckerFactory campaignSubObjectAccessCheckerFactory;

    @Autowired
    public BannerWithAdGroupIdAddValidationTypeSupport(
            BannerWithAdGroupIdValidationContainerFiller containerFiller,
            CampaignSubObjectAccessCheckerFactory campaignSubObjectAccessCheckerFactory) {
        this.containerFiller = containerFiller;
        this.campaignSubObjectAccessCheckerFactory = campaignSubObjectAccessCheckerFactory;
    }

    @Override
    public Class<BannerWithAdGroupId> getTypeClass() {
        return BannerWithAdGroupId.class;
    }

    @Override
    public ValidationResult<List<BannerWithAdGroupId>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithAdGroupId>, Defect> vr) {
        if (container.isPartOfComplexOperation()) {
            return vr;
        }

        ListValidationBuilder<BannerWithAdGroupId, Defect> lvb = new ListValidationBuilder<>(vr);
        List<BannerWithAdGroupId> banners = vr.getValue();
        BannerWithAdGroupIdValidationContainer adGroupIdValidationContainer =
                containerFiller.createAndFillContainerForAdd(
                        container,
                        banners,
                        BannerWithAdGroupId.AD_GROUP_ID);

        CampaignSubObjectAccessConstraint campaignLevelAccessConstraint = campaignSubObjectAccessCheckerFactory
                .newAdGroupChecker(container.getOperatorUid(), container.getClientId(),
                        adGroupIdValidationContainer.getExistingAdGroupIds())
                .createAdGroupValidator(CampaignAccessType.READ_WRITE,
                        AD_GROUP_ACCESS_DEFECTS_FOR_BANNER.toBuilder()
                                .withArchivedModification(addToArchivedCampaignNotAllowed())
                                .build())
                .getAccessConstraint();

        lvb.checkEachBy(new BannerWithAdGroupIdValidator(), When.isFalse(container.isAdGroupExternal()));

        lvb.checkEachBy(new BannerToAdGroupConnectionValidator<>(BannerWithAdGroupId.AD_GROUP_ID,
                BannerTypeValidationPredicates::isInternalBanner,
                BannerTypeValidationPredicates::isPerformanceBannerMain,
                adGroupIdValidationContainer,
                campaignLevelAccessConstraint,
                true));
        lvb.checkEach(isBannerClassCorrespondTo(
                b -> adGroupIdValidationContainer.getAdGroupType(b.getAdGroupId())), When.isValid());
        return lvb.getResult();
    }

    private static Constraint<BannerWithAdGroupId, Defect> isBannerClassCorrespondTo(
            Function<BannerWithAdGroupId, AdGroupType> adGroupTypeMapper) {
        return b -> BannerConstraints
                .isBannerClassCorrespondTo(adGroupTypeMapper.apply(b)).apply(b);
    }
}
