package ru.yandex.direct.core.entity.banner.type.adgroupid;

import java.util.Collection;
import java.util.List;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
public class BannerWithAdGroupIdRepositoryTypeSupport
        extends AbstractBannerRepositoryTypeSupport<BannerWithAdGroupId> {

    private final JooqMapper<BannerWithAdGroupId> mapper;

    @Autowired
    public BannerWithAdGroupIdRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
        mapper = createMapper();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(PHRASES, JoinType.JOIN, PHRASES.PID.eq(BANNERS.PID)));
    }

    @Override
    public Collection<Field<?>> getFields() {
        return mapper.getFieldsToRead();
    }

    @Override
    public <M extends BannerWithAdGroupId> void fillFromRecord(M model, Record record) {
        mapper.fromDb(record, model);
    }

    @Override
    public final void pushToInsert(InsertHelperAggregator insertHelperAggregator, BannerWithAdGroupId model) {
        insertHelperAggregator.getOrCreate(BANNERS.BID.getTable()).add(mapper, model);
    }

    @Override
    public final void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                                    Collection<AppliedChanges<BannerWithAdGroupId>> appliedChanges) {
        updateHelperAggregator.getOrCreate(BANNERS.BID).processUpdateAll(mapper, appliedChanges);
    }

    @Override
    public Class<BannerWithAdGroupId> getTypeClass() {
        return BannerWithAdGroupId.class;
    }

    private static JooqMapper<BannerWithAdGroupId> createMapper() {
        return JooqMapperBuilder.<BannerWithAdGroupId>builder()
                .readProperty(BannerWithAdGroupId.ID, fromField(Banners.BANNERS.BID))
                .map(property(BannerWithAdGroupId.AD_GROUP_ID, BANNERS.PID))
                .build();
    }
}
