package ru.yandex.direct.core.entity.banner.type.adgroupid;

import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;

public class BannerWithAdGroupIdValidationContainer {
    private final Map<Long, AdGroupForBannerOperation> existingAdGroups;
    private final Map<Long, Long> groupBannersCounter;
    private final Map<Long, Long> groupNotArchivedBannersCounter;
    private final Map<Long, Integer> campaignBannersCounter;
    private final Map<Long, CampaignType> uacCampaignIdToType;

    private BannerWithAdGroupIdValidationContainer(
            Map<Long, AdGroupForBannerOperation> existingAdGroups,
            Map<Long, Long> groupBannersCounter,
            Map<Long, Long> groupNotArchivedBannersCounter,
            Map<Long, Integer> campaignBannersCounter,
            Map<Long, CampaignType> uacCampaignIdToType) {
        this.existingAdGroups = existingAdGroups;
        this.groupBannersCounter = groupBannersCounter;
        this.groupNotArchivedBannersCounter = groupNotArchivedBannersCounter;
        this.campaignBannersCounter = campaignBannersCounter;
        this.uacCampaignIdToType = uacCampaignIdToType;
    }

    public static BannerWithAdGroupIdValidationContainer create(
            Map<Long, AdGroupForBannerOperation> existingAdGroups,
            Map<Long, Long> groupBannersCounter,
            Map<Long, Long> groupNotArchivedBannersCounter,
            Map<Long, Integer> campaignBannersCounter,
            Map<Long, CampaignType> uacCampaignIdToType
    ) {
        return new BannerWithAdGroupIdValidationContainer(existingAdGroups, groupBannersCounter,
                groupNotArchivedBannersCounter, campaignBannersCounter, uacCampaignIdToType);
    }

    Map<Long, Long> getGroupBannersCounter() {
        return groupBannersCounter;
    }

    Map<Long, Long> getGroupNotArchivedBannersCounter() {
        return groupNotArchivedBannersCounter;
    }

    Map<Long, Integer> getCampaignBannersCounter() {
        return campaignBannersCounter;
    }

    public Set<Long> getExistingAdGroupIds() {
        return existingAdGroups.keySet();
    }

    public boolean isUniversalCampaign(Long campaignId) {
        return campaignId != null && uacCampaignIdToType.containsKey(campaignId);
    }

    public boolean isUniversalTextCampaign(Long campaignId) {
        return isUniversalCampaign(campaignId) && uacCampaignIdToType.get(campaignId).equals(CampaignType.TEXT);
    }

    public boolean isUniversalMobileContentCampaign(Long campaignId) {
        return isUniversalCampaign(campaignId) && uacCampaignIdToType.get(campaignId).equals(CampaignType.MOBILE_CONTENT);
    }

    public AdGroupForBannerOperation getAdGroup(Long adGroupId) {
        return existingAdGroups.get(adGroupId);
    }

    @Nullable
    public AdGroupType getAdGroupType(Long adGroupId) {
        var adGroup = getAdGroup(adGroupId);
        return adGroup == null ? null : adGroup.getType();
    }
}
