package ru.yandex.direct.core.entity.banner.type.adgroupid;

import java.util.HashSet;
import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.banner.container.BannerOperationContainerUtils;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

import static java.util.Collections.emptyMap;
import static java.util.stream.Collectors.counting;
import static java.util.stream.Collectors.groupingBy;

@Component
public class BannerWithAdGroupIdValidationContainerFiller {

    private final BannerRelationsRepository bannerRelationsRepository;
    private final AdGroupRepository adGroupRepository;
    private final CampaignRepository campaignRepository;

    @Autowired
    public BannerWithAdGroupIdValidationContainerFiller(
            BannerRelationsRepository bannerRelationsRepository,
            AdGroupRepository adGroupRepository,
            CampaignRepository campaignRepository) {
        this.bannerRelationsRepository = bannerRelationsRepository;
        this.adGroupRepository = adGroupRepository;
        this.campaignRepository = campaignRepository;
    }

    public <B extends ModelWithId> BannerWithAdGroupIdValidationContainer createAndFillContainerForAdd(
            BannersAddOperationContainer container,
            List<B> banners,
            ModelProperty<? super B, Long> adGroupIdProperty) {
        Map<Long, AdGroupForBannerOperation> existingAdGroups =
                BannerOperationContainerUtils.getAdGroupIdToAdGroup(container);
        return createAndFillContainer(container.getShard(),
                existingAdGroups,
                banners, adGroupIdProperty, true);
    }

    public <B extends ModelWithId> BannerWithAdGroupIdValidationContainer createAndFillContainer(
            int shard,
            List<B> banners,
            ModelProperty<? super B, Long> adGroupIdProperty,
            boolean isAddOperation
    ) {
        var adGroupIds = StreamEx.of(banners).map(adGroupIdProperty::get).nonNull().toSet();
        var existingAdGroups = adGroupRepository.getAdGroupsForBannerOperation(shard, adGroupIds, null);

        return createAndFillContainer(shard,
                existingAdGroups, banners, adGroupIdProperty,
                isAddOperation);
    }

    private <B extends ModelWithId> BannerWithAdGroupIdValidationContainer createAndFillContainer(
            int shard,
            Map<Long, AdGroupForBannerOperation> existingAdGroups,
            List<B> banners,
            ModelProperty<? super B, Long> adGroupIdProperty,
            boolean isAddOperation) {
        var existingAdGroupIds = existingAdGroups.keySet();

        Map<Long, CampaignType> uacCampaignIdToType = emptyMap();
        Map<Long, Integer> campaignBannersCounter = emptyMap();
        Map<Long, Long> groupBannersCounter;
        Map<Long, Long> groupNotArchivedBannersCounter;
        if (isAddOperation) {
            var campaignIdsByExistingAdGroupIds =
                    adGroupRepository.getCampaignIdsByAdGroupIds(shard, existingAdGroupIds);
            groupBannersCounter = banners.stream()
                    .filter(b -> adGroupIdProperty.get(b) != null)
                    .collect(groupingBy(adGroupIdProperty::get, counting()));
            groupNotArchivedBannersCounter = banners.stream()
                    .filter(b -> adGroupIdProperty.get(b) != null)
                    .filter(b -> b instanceof BannerWithSystemFields)
                    .filter(b -> !Boolean.TRUE.equals(((BannerWithSystemFields) b).getStatusArchived()))
                    .collect(groupingBy(adGroupIdProperty::get, counting()));

            boolean hasInternalGroups = existingAdGroups.values().stream()
                    .anyMatch(adGroupSimple -> adGroupSimple.getType() == AdGroupType.INTERNAL);

            uacCampaignIdToType = campaignRepository.getUniversalCampaignType(shard,
                    new HashSet<>(campaignIdsByExistingAdGroupIds.values()));
            if (hasInternalGroups || !uacCampaignIdToType.isEmpty()) {
                campaignBannersCounter = EntryStream.of(campaignIdsByExistingAdGroupIds)
                        .invert()
                        .mapValues(adGroupId -> groupBannersCounter.getOrDefault(adGroupId, 0L))
                        .mapValues(Long::intValue)
                        .append(bannerRelationsRepository.getBannersCounterByCampaigns(shard,
                                campaignIdsByExistingAdGroupIds.values()))
                        .toMap(Integer::sum);
            }

            Map<Long, Pair<Long, Long>> existsBannersCounter =
                    bannerRelationsRepository.getBannersCountersByAdgroups(shard, groupBannersCounter.keySet());
            existsBannersCounter.forEach((adGroupId, counter) -> {
                groupBannersCounter.merge(adGroupId, counter.getLeft(), Long::sum);
                groupNotArchivedBannersCounter.merge(adGroupId, counter.getRight(), Long::sum);
            });

        } else {
            // счетчики баннеров в группе и в кампании актуальны только для добавления
            groupBannersCounter = emptyMap();
            groupNotArchivedBannersCounter = emptyMap();
        }

        return BannerWithAdGroupIdValidationContainer.create(existingAdGroups, groupBannersCounter,
                groupNotArchivedBannersCounter, campaignBannersCounter, uacCampaignIdToType);
    }


}
