package ru.yandex.direct.core.entity.banner.type.adgroupid;

import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class BannerWithAdGroupIdValidator implements Validator<BannerWithAdGroupId, Defect> {

    @Override
    public ValidationResult<BannerWithAdGroupId, Defect> apply(BannerWithAdGroupId banner) {
        ModelItemValidationBuilder<BannerWithAdGroupId> vb = ModelItemValidationBuilder.of(banner);
        vb.item(BannerWithAdGroupId.AD_GROUP_ID).check(notNull());
        return vb.getResult();
    }
}
