package ru.yandex.direct.core.entity.banner.type.aggregatordomain;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithAggregatorDomain;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class BannerWithAggregatorDomainAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithAggregatorDomain> {

    private final AggregatorDomainProcessor processor;

    @Autowired
    public BannerWithAggregatorDomainAddOperationTypeSupport(AggregatorDomainProcessor processor) {
        this.processor = processor;
    }

    @Override
    public Class<BannerWithAggregatorDomain> getTypeClass() {
        return BannerWithAggregatorDomain.class;
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext, BannersAddOperationContainer container,
                                                   List<BannerWithAggregatorDomain> models) {
        processor.addAggregatorDomains(dslContext, filterList(models,
                banner -> banner.getHref() != null || banner.getDomain() != null));
    }

}
