package ru.yandex.direct.core.entity.banner.type.aggregatordomain;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithAggregatorDomain;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.core.entity.banner.model.BannerWithAggregatorDomain.AGGREGATOR_DOMAIN;
import static ru.yandex.direct.dbschema.ppc.Tables.AGGREGATOR_DOMAINS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class BannerWithAggregatorDomainRepositoryTypeSupport
        extends AbstractBannerRepositoryTypeSupport<BannerWithAggregatorDomain> {

    private final JooqMapper<BannerWithAggregatorDomain> jooqMapper;

    @Autowired
    public BannerWithAggregatorDomainRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
        jooqMapper = createMapper();
    }

    @Override
    public Collection<Field<?>> getFields() {
        return jooqMapper.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(AGGREGATOR_DOMAINS, JoinType.LEFT_OUTER_JOIN, AGGREGATOR_DOMAINS.BID.eq(BANNERS.BID)));
    }

    @Override
    public <M extends BannerWithAggregatorDomain> void fillFromRecord(M model, Record record) {
        jooqMapper.fromDb(record, model);
    }

    @Override
    public Class<BannerWithAggregatorDomain> getTypeClass() {
        return BannerWithAggregatorDomain.class;
    }

    private JooqMapper<BannerWithAggregatorDomain> createMapper() {
        return JooqMapperBuilder.<BannerWithAggregatorDomain>builder()
                .map(property(AGGREGATOR_DOMAIN, AGGREGATOR_DOMAINS.PSEUDO_DOMAIN))
                .build();
    }
}
